/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.HashCodeExclude;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HashCodeBuilderTest
extends AbstractLangTest {
    @Test
    public void testBoolean() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(true).toHashCode());
        Assertions.assertEquals((int)630, (int)new HashCodeBuilder(17, 37).append(false).toHashCode());
    }

    @Test
    public void testBooleanArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((boolean[])null).toHashCode());
        boolean[] obj = new boolean[2];
        Assertions.assertEquals((int)23311, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = true;
        Assertions.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = false;
        Assertions.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testBooleanArrayAsObject() {
        boolean[] obj = new boolean[2];
        Assertions.assertEquals((int)23311, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = true;
        Assertions.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = false;
        Assertions.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testBooleanMultiArray() {
        boolean[][] obj = new boolean[2][];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[0];
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[1];
        Assertions.assertEquals((int)23310, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[2];
        Assertions.assertEquals((int)862507, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0][0] = true;
        Assertions.assertEquals((int)861138, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[1] = new boolean[1];
        Assertions.assertEquals((int)861139, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
    }

    @Test
    public void testByte() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((byte)0).toHashCode());
        Assertions.assertEquals((int)752, (int)new HashCodeBuilder(17, 37).append((byte)123).toHashCode());
    }

    @Test
    public void testByteArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((byte[])null).toHashCode());
        byte[] obj = new byte[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testByteArrayAsObject() {
        byte[] obj = new byte[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testChar() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append('\u0000').toHashCode());
        Assertions.assertEquals((int)1863, (int)new HashCodeBuilder(17, 37).append('\u04d2').toHashCode());
    }

    @Test
    public void testCharArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((char[])null).toHashCode());
        char[] obj = new char[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testCharArrayAsObject() {
        char[] obj = new char[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testConstructorExEvenFirst() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HashCodeBuilder(2, 3));
    }

    @Test
    public void testConstructorExEvenNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HashCodeBuilder(-2, -2));
    }

    @Test
    public void testConstructorExEvenSecond() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HashCodeBuilder(3, 2));
    }

    @Test
    public void testConstructorExZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HashCodeBuilder(0, 0));
    }

    @Test
    public void testDouble() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0.0).toHashCode());
        double d = 1234567.89;
        long l = Double.doubleToLongBits(1234567.89);
        Assertions.assertEquals((int)(629 + (int)(l ^ l >> 32)), (int)new HashCodeBuilder(17, 37).append(1234567.89).toHashCode());
    }

    @Test
    public void testDoubleArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((double[])null).toHashCode());
        double[] obj = new double[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        Assertions.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        Assertions.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testDoubleArrayAsObject() {
        double[] obj = new double[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        Assertions.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        Assertions.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testEquals() {
        HashCodeBuilder hcb1 = new HashCodeBuilder(17, 37).append(1).append('a');
        HashCodeBuilder hcb2 = new HashCodeBuilder(17, 37).append(1).append('a');
        HashCodeBuilder hcb3 = new HashCodeBuilder(17, 37).append(2).append('c');
        Assertions.assertEquals((Object)hcb1, (Object)hcb1);
        Assertions.assertEquals((Object)hcb1, (Object)hcb2);
        Assertions.assertEquals((Object)hcb2, (Object)hcb1);
        Assertions.assertNotEquals((Object)hcb1, (Object)hcb3);
        Assertions.assertNotEquals((Object)hcb2, (Object)hcb3);
    }

    @Test
    public void testFloat() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0.0f).toHashCode());
        float f = 1234.89f;
        int i = Float.floatToIntBits(1234.89f);
        Assertions.assertEquals((int)(629 + i), (int)new HashCodeBuilder(17, 37).append(1234.89f).toHashCode());
    }

    @Test
    public void testFloatArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((float[])null).toHashCode());
        float[] obj = new float[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        Assertions.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        Assertions.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testFloatArrayAsObject() {
        float[] obj = new float[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        Assertions.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        Assertions.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testInt() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0).toHashCode());
        Assertions.assertEquals((int)124085, (int)new HashCodeBuilder(17, 37).append(123456).toHashCode());
    }

    @Test
    public void testIntArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((int[])null).toHashCode());
        int[] obj = new int[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testIntArrayAsObject() {
        int[] obj = new int[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testLong() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0L).toHashCode());
        Assertions.assertEquals((int)123457418, (int)new HashCodeBuilder(17, 37).append(123456789L).toHashCode());
    }

    @Test
    public void testLongArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((long[])null).toHashCode());
        long[] obj = new long[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testLongArrayAsObject() {
        long[] obj = new long[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testObject() {
        Object obj = null;
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj = new Object();
        Assertions.assertEquals((int)(629 + obj.hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testObjectArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((Object[])null).toHashCode());
        Object[] obj = new Object[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = new Object();
        Assertions.assertEquals((int)((629 + obj[0].hashCode()) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = new Object();
        Assertions.assertEquals((int)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testObjectArrayAsObject() {
        Object[] obj = new Object[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = new Object();
        Assertions.assertEquals((int)((629 + obj[0].hashCode()) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = new Object();
        Assertions.assertEquals((int)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testObjectBuild() {
        Object obj = null;
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(obj).build());
        obj = new Object();
        Assertions.assertEquals((int)(629 + obj.hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).build());
    }

    @Test
    public void testReflectionHashCode() {
        Assertions.assertEquals((int)629, (int)HashCodeBuilder.reflectionHashCode((Object)new TestObject(0), (String[])new String[0]));
        Assertions.assertEquals((int)124085, (int)HashCodeBuilder.reflectionHashCode((Object)new TestObject(123456), (String[])new String[0]));
    }

    @Test
    public void testReflectionHashCodeEx1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestObject(0), (boolean)true));
    }

    @Test
    public void testReflectionHashCodeEx2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestObject(0), (boolean)true));
    }

    @Test
    public void testReflectionHashCodeEx3() {
        Assertions.assertThrows(NullPointerException.class, () -> HashCodeBuilder.reflectionHashCode((int)13, (int)19, null, (boolean)true));
    }

    @Test
    public void testReflectionHashCodeExcludeFields() {
        TestObjectWithMultipleFields x = new TestObjectWithMultipleFields(1, 2, 3);
        Assertions.assertEquals((int)862583, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        Assertions.assertEquals((int)862583, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])null));
        Assertions.assertEquals((int)862583, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        Assertions.assertEquals((int)862583, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"xxx"}));
        Assertions.assertEquals((int)23313, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two"}));
        Assertions.assertEquals((int)23312, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"three"}));
        Assertions.assertEquals((int)630, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two", "three"}));
        Assertions.assertEquals((int)17, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three"}));
        Assertions.assertEquals((int)17, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three", "xxx"}));
    }

    @Test
    public void testReflectionHierarchyHashCode() {
        Assertions.assertEquals((int)23273, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (String[])new String[0]));
        Assertions.assertEquals((int)861101, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (boolean)true));
        Assertions.assertEquals((int)438659, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (String[])new String[0]));
        Assertions.assertEquals((int)11785967, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (boolean)true));
    }

    @Test
    public void testReflectionHierarchyHashCodeEx1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestSubObject(0, 0, 0), (boolean)true));
    }

    @Test
    public void testReflectionHierarchyHashCodeEx2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestSubObject(0, 0, 0), (boolean)true));
    }

    @Test
    public void testReflectionObjectCycle() {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        a.hashCode();
        Assertions.assertNull((Object)HashCodeBuilder.getRegistry());
        b.hashCode();
        Assertions.assertNull((Object)HashCodeBuilder.getRegistry());
    }

    @Test
    public void testShort() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((short)0).toHashCode());
        Assertions.assertEquals((int)12974, (int)new HashCodeBuilder(17, 37).append((short)12345).toHashCode());
    }

    @Test
    public void testShortArray() {
        Assertions.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((short[])null).toHashCode());
        short[] obj = new short[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testShortArrayAsObject() {
        short[] obj = new short[2];
        Assertions.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assertions.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assertions.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testSuper() {
        Object obj = new Object();
        Assertions.assertEquals((int)(1408 + obj.hashCode()), (int)new HashCodeBuilder(17, 37).appendSuper(new HashCodeBuilder(19, 41).append(obj).toHashCode()).toHashCode());
    }

    @Test
    public void testToHashCodeEqualsHashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(17, 37).append(new Object()).append('a');
        Assertions.assertEquals((int)hcb.toHashCode(), (int)hcb.hashCode(), (String)"hashCode() is no longer returning the same value as toHashCode() - see LANG-520");
    }

    @Test
    public void testToHashCodeExclude() {
        TestObjectHashCodeExclude one = new TestObjectHashCodeExclude(1, 2);
        TestObjectHashCodeExclude2 two = new TestObjectHashCodeExclude2(1, 2);
        Assertions.assertEquals((int)631, (int)HashCodeBuilder.reflectionHashCode((Object)one, (String[])new String[0]));
        Assertions.assertEquals((int)17, (int)HashCodeBuilder.reflectionHashCode((Object)two, (String[])new String[0]));
    }

    static class TestSubObject
    extends TestObject {
        private int b;
        private transient int t;

        TestSubObject() {
            super(0);
        }

        TestSubObject(int a, int b, int t) {
            super(a);
            this.b = b;
            this.t = t;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestSubObject)) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }

        @Override
        public int hashCode() {
            return this.b * 17 + super.hashCode();
        }
    }

    static class TestObjectWithMultipleFields {
        private int one = 0;
        private int two = 0;
        private int three = 0;

        TestObjectWithMultipleFields(int one, int two, int three) {
            this.one = one;
            this.two = two;
            this.three = three;
        }
    }

    static class TestObjectHashCodeExclude2 {
        @HashCodeExclude
        private final int a;
        @HashCodeExclude
        private final int b;

        TestObjectHashCodeExclude2(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObjectHashCodeExclude {
        @HashCodeExclude
        private final int a;
        private final int b;

        TestObjectHashCodeExclude(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObject {
        private int a;

        TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestObject)) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public int getA() {
            return this.a;
        }

        public int hashCode() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

