/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class SystemPropertiesTest {
    private boolean isJava11OrGreater() {
        return SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11);
    }

    @Test
    public void testGetAwtToolkit() {
        Assertions.assertDoesNotThrow(SystemProperties::getAwtToolkit);
    }

    @Test
    public void testGetFileEncoding() {
        Assertions.assertNotNull((Object)SystemProperties.getFileEncoding());
    }

    @Test
    public void testGetFileSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getFileSeparator());
    }

    @Test
    public void testGetJavaAwtFonts() {
        Assertions.assertNull((Object)SystemProperties.getJavaAwtFonts());
    }

    @Test
    public void testGetJavaAwtGraphicsenv() {
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtGraphicsenv);
    }

    @Test
    public void testGetJavaAwtHeadless() {
        Assertions.assertNull((Object)SystemProperties.getJavaAwtHeadless());
    }

    @Test
    public void testGetJavaAwtPrinterjob() {
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtPrinterjob);
    }

    @Test
    public void testGetJavaClassPath() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaClassPath());
    }

    @Test
    public void testGetJavaClassVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaClassVersion());
    }

    @Test
    public void testGetJavaCompiler() {
        if (SystemUtils.IS_JAVA_14) {
            Assertions.assertNotNull((Object)SystemProperties.getJavaCompiler());
        }
    }

    @Test
    public void testGetJavaEndorsedDirs() {
        if (this.isJava11OrGreater()) {
            Assertions.assertNull((Object)SystemProperties.getJavaEndorsedDirs());
        } else {
            Assertions.assertNotNull((Object)SystemProperties.getJavaExtDirs());
        }
    }

    @Test
    public void testGetJavaExtDirs() {
        if (this.isJava11OrGreater()) {
            Assertions.assertNull((Object)SystemProperties.getJavaExtDirs());
        } else {
            Assertions.assertNotNull((Object)SystemProperties.getJavaExtDirs());
        }
    }

    @Test
    public void testGetJavaHome() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaHome());
    }

    @Test
    public void testGetJavaIoTmpdir() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaIoTmpdir());
    }

    @Test
    public void testGetJavaLibraryPath() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaLibraryPath());
    }

    @Test
    public void testGetJavaLocaleProviders() {
        Assumptions.assumeTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        Assertions.assertNull((Object)SystemProperties.getJavaLocaleProviders(), (String)SystemProperties.getJavaVersion());
    }

    @Test
    public void testGetJavaRuntimeName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaRuntimeName());
    }

    @Test
    public void testGetJavaRuntimeVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaRuntimeVersion());
    }

    @Test
    public void testGetJavaSpecificationName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationName());
    }

    @Test
    public void testGetJavaSpecificationVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationVendor());
    }

    @Test
    public void testGetJavaSpecificationVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationVersion());
    }

    @Test
    public void testGetJavaUtilPrefsPreferencesFactory() {
        Assertions.assertNull((Object)SystemProperties.getJavaUtilPrefsPreferencesFactory());
    }

    @Test
    public void testGetJavaVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVendor());
    }

    @Test
    public void testGetJavaVendorUrl() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVendorUrl());
    }

    @Test
    public void testGetJavaVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVersion());
    }

    @Test
    public void testGetJavaVmInfo() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmInfo());
    }

    @Test
    public void testGetJavaVmName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmName());
    }

    @Test
    public void testGetJavaVmSpecificationName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationName());
    }

    @Test
    public void testGetJavaVmSpecificationVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationVendor());
    }

    @Test
    public void testGetJavaVmSpecificationVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationVersion());
    }

    @Test
    public void testGetJavaVmVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmVendor());
    }

    @Test
    public void testGetJavaVmVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmVersion());
    }

    @Test
    public void testGetLineSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator());
    }

    @Test
    public void testGetOsArch() {
        Assertions.assertNotNull((Object)SystemProperties.getOsArch());
    }

    @Test
    public void testGetOsName() {
        Assertions.assertNotNull((Object)SystemProperties.getOsName());
    }

    @Test
    public void testGetBoolean() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Boolean.toString(Boolean.TRUE));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)SystemProperties.getBoolean((String)key, () -> false));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)SystemProperties.getBoolean((String)absentKey, () -> Boolean.TRUE));
            Assertions.assertEquals((Object)false, (Object)SystemProperties.getBoolean((String)absentKey, () -> false));
            Assertions.assertEquals((Object)false, (Object)SystemProperties.getBoolean((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void testGetInt() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Integer.toString(Integer.MAX_VALUE));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)SystemProperties.getInt((String)key, () -> 0));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)SystemProperties.getInt((String)absentKey, () -> Integer.MAX_VALUE));
            Assertions.assertEquals((int)0, (int)SystemProperties.getInt((String)absentKey, () -> 0));
            Assertions.assertEquals((int)0, (int)SystemProperties.getInt((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void testGetLong() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Long.toString(Long.MAX_VALUE));
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)SystemProperties.getLong((String)key, () -> 0L));
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)SystemProperties.getLong((String)absentKey, () -> Long.MAX_VALUE));
            Assertions.assertEquals((long)0L, (long)SystemProperties.getLong((String)absentKey, () -> 0L));
            Assertions.assertEquals((long)0L, (long)SystemProperties.getLong((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void testGetOsVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getOsVersion());
    }

    @Test
    public void testGetPathSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getPathSeparator());
    }

    @Test
    public void testGetUserCountry() {
        Assertions.assertDoesNotThrow(SystemProperties::getUserCountry);
    }

    @Test
    public void testGetUserDir() {
        Assertions.assertNotNull((Object)SystemProperties.getUserDir());
    }

    @Test
    public void testGetUserHome() {
        Assertions.assertNotNull((Object)SystemProperties.getUserHome());
    }

    @Test
    public void testGetUserLanguage() {
        Assertions.assertNotNull((Object)SystemProperties.getUserLanguage());
    }

    @Test
    public void testGetUserName() {
        Assertions.assertNotNull((Object)SystemProperties.getUserName());
    }

    @Test
    public void testGetUserTimezone() {
        Assertions.assertDoesNotThrow(SystemProperties::getUserTimezone);
    }
}

