/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Enum64;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Month;
import org.apache.commons.lang3.TooMany;
import org.apache.commons.lang3.Traffic;
import org.apache.commons.lang3.Traffic2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnumUtilsTest
extends AbstractLangTest {
    private void assertArrayEquals(long[] actual, long ... expected) {
        Assertions.assertArrayEquals((long[])expected, (long[])actual);
    }

    @Test
    public void test_generateBitVector() {
        Assertions.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.noneOf(Traffic.class)));
        Assertions.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED)));
        Assertions.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER)));
        Assertions.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.GREEN)));
        Assertions.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)));
        Assertions.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)));
        Assertions.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)));
        Assertions.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A31)));
        Assertions.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A32)));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
    }

    @Test
    public void test_generateBitVector_longClass() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVector(TooMany.class, EnumSet.of(TooMany.A1)));
    }

    @Test
    public void test_generateBitVector_longClassWithArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVector(TooMany.class, (Enum[])new TooMany[]{TooMany.A1}));
    }

    @Test
    public void test_generateBitVector_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVector((Class)rawType, (Iterable)rawList));
    }

    @Test
    public void test_generateBitVector_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVector((Class)rawType, (Enum[])new Enum[0]));
    }

    @Test
    public void test_generateBitVector_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVector(Traffic.class, (Enum[])null));
    }

    @Test
    public void test_generateBitVector_nullArrayElement() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null}));
    }

    @Test
    public void test_generateBitVector_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVector(null, EnumSet.of(Traffic.RED)));
    }

    @Test
    public void test_generateBitVector_nullClassWithArray() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVector(null, (Enum[])new Traffic[]{Traffic.RED}));
    }

    @Test
    public void test_generateBitVector_nullElement() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVector(Traffic.class, Arrays.asList(Traffic.RED, null)));
    }

    @Test
    public void test_generateBitVector_nullIterable() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVector(Traffic.class, (Iterable)null));
    }

    @Test
    public void test_generateBitVectorFromArray() {
        Assertions.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[0]));
        Assertions.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}));
        Assertions.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}));
        Assertions.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}));
        Assertions.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}));
        Assertions.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}));
        Assertions.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}));
        Assertions.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}));
        Assertions.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
    }

    @Test
    public void test_generateBitVectors() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.noneOf(Traffic.class)), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED)), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER)), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.GREEN)), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A31)), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A32)), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.M2)), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.L2, TooMany.M2)), 1L, Long.MIN_VALUE);
    }

    @Test
    public void test_generateBitVectors_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVectors((Class)rawType, (Iterable)rawList));
    }

    @Test
    public void test_generateBitVectors_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVectors((Class)rawType, (Enum[])new Enum[0]));
    }

    @Test
    public void test_generateBitVectors_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVectors(Traffic.class, (Enum[])null));
    }

    @Test
    public void test_generateBitVectors_nullArrayElement() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null}));
    }

    @Test
    public void test_generateBitVectors_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVectors(null, EnumSet.of(Traffic.RED)));
    }

    @Test
    public void test_generateBitVectors_nullClassWithArray() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVectors(null, (Enum[])new Traffic[]{Traffic.RED}));
    }

    @Test
    public void test_generateBitVectors_nullElement() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVectors(Traffic.class, Arrays.asList(Traffic.RED, null)));
    }

    @Test
    public void test_generateBitVectors_nullIterable() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.generateBitVectors(null, (Iterable)null));
    }

    @Test
    public void test_generateBitVectorsFromArray() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[0]), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.M2}), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.L2, TooMany.M2}), 1L, Long.MIN_VALUE);
    }

    @Test
    public void test_getEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN"));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE"));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, null));
    }

    @Test
    public void test_getEnum_defaultEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.RED));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", null));
    }

    @Test
    public void test_getEnum_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assertions.assertNull((Object)EnumUtils.getEnum(rawType, (String)"rawType"));
    }

    @Test
    public void test_getEnum_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Traffic cfr_ignored_0 = (Traffic)EnumUtils.getEnum((Class)null, (String)"PURPLE");
        });
    }

    @Test
    public void test_getEnumIgnoreCase() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"red"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null));
    }

    @Test
    public void test_getEnumIgnoreCase_defaultEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"red", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"Amber", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"grEEn", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"PURPLE", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"purple", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"pUrPlE", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.RED));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"PURPLE", null));
    }

    @Test
    public void test_getEnumIgnoreCase_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(rawType, (String)"rawType"));
    }

    @Test
    public void test_getEnumIgnoreCase_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Traffic cfr_ignored_0 = (Traffic)EnumUtils.getEnumIgnoreCase((Class)null, (String)"PURPLE");
        });
    }

    @Test
    public void test_getEnumList() {
        List test = EnumUtils.getEnumList(Traffic.class);
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertEquals((Object)((Object)Traffic.RED), test.get(0));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), test.get(1));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), test.get(2));
    }

    @Test
    public void test_getEnumMap() {
        Map test = EnumUtils.getEnumMap(Traffic.class);
        Assertions.assertEquals((Object)"{RED=RED, AMBER=AMBER, GREEN=GREEN}", (Object)test.toString(), (String)"getEnumMap not created correctly");
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)((Object)Traffic.RED), test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("AMBER"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), test.get("AMBER"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), test.get("GREEN"));
        Assertions.assertFalse((boolean)test.containsKey("PURPLE"));
    }

    @Test
    public void test_getEnumMap_keyFunction() {
        Map test = EnumUtils.getEnumMap(Month.class, Month::getId);
        Assertions.assertEquals((Object)"{1=JAN, 2=FEB, 3=MAR, 4=APR, 5=MAY, 6=JUN, 7=JUL, 8=AUG, 9=SEP, 10=OCT, 11=NOV, 12=DEC}", (Object)test.toString(), (String)"getEnumMap not created correctly");
        Assertions.assertEquals((int)12, (int)test.size());
        Assertions.assertFalse((boolean)test.containsKey(0));
        Assertions.assertTrue((boolean)test.containsKey(1));
        Assertions.assertEquals((Object)((Object)Month.JAN), test.get(1));
        Assertions.assertTrue((boolean)test.containsKey(2));
        Assertions.assertEquals((Object)((Object)Month.FEB), test.get(2));
        Assertions.assertTrue((boolean)test.containsKey(3));
        Assertions.assertEquals((Object)((Object)Month.MAR), test.get(3));
        Assertions.assertTrue((boolean)test.containsKey(4));
        Assertions.assertEquals((Object)((Object)Month.APR), test.get(4));
        Assertions.assertTrue((boolean)test.containsKey(5));
        Assertions.assertEquals((Object)((Object)Month.MAY), test.get(5));
        Assertions.assertTrue((boolean)test.containsKey(6));
        Assertions.assertEquals((Object)((Object)Month.JUN), test.get(6));
        Assertions.assertTrue((boolean)test.containsKey(7));
        Assertions.assertEquals((Object)((Object)Month.JUL), test.get(7));
        Assertions.assertTrue((boolean)test.containsKey(8));
        Assertions.assertEquals((Object)((Object)Month.AUG), test.get(8));
        Assertions.assertTrue((boolean)test.containsKey(9));
        Assertions.assertEquals((Object)((Object)Month.SEP), test.get(9));
        Assertions.assertTrue((boolean)test.containsKey(10));
        Assertions.assertEquals((Object)((Object)Month.OCT), test.get(10));
        Assertions.assertTrue((boolean)test.containsKey(11));
        Assertions.assertEquals((Object)((Object)Month.NOV), test.get(11));
        Assertions.assertTrue((boolean)test.containsKey(12));
        Assertions.assertEquals((Object)((Object)Month.DEC), test.get(12));
        Assertions.assertFalse((boolean)test.containsKey(13));
    }

    @Test
    public void test_getEnumSystemProperty() {
        String key = this.getClass().getName();
        System.setProperty(key, Traffic.RED.toString());
        try {
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, (String)key, null));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, (String)"?", (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(null, null, (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(null, (String)"?", (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, null, (Enum)Traffic.RED));
        }
        finally {
            System.getProperties().remove(key);
        }
    }

    @Test
    public void test_getFirstEnumIgnoreCase_defaultEnum() {
        Function<Traffic2, String> f = Traffic2::getLabel;
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"***red***", f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"**Amber**", f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"*grEEn*", f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"PURPLE", f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"purple", f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"pUrPlE", f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.RED));
        Assertions.assertNull((Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"PURPLE", f, null));
    }

    @Test
    public void test_isValidEnum() {
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"RED"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"AMBER"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"GREEN"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"PURPLE"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, null));
    }

    @Test
    public void test_isValidEnum_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.isValidEnum(null, (String)"PURPLE"));
    }

    @Test
    public void test_isValidEnumIgnoreCase() {
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"red"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, null));
    }

    @Test
    public void test_isValidEnumIgnoreCase_nullClass() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.isValidEnumIgnoreCase(null, (String)"PURPLE"));
    }

    @Test
    public void test_processBitVector() {
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVector(Traffic.class, (long)0L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVector(Traffic.class, (long)1L));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)2L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)3L));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)4L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)5L));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)6L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)7L));
        Assertions.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x80000000L));
        Assertions.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x100000000L));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
    }

    @Test
    public void test_processBitVector_longClass() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnumUtils.processBitVector(TooMany.class, (long)0L));
    }

    @Test
    public void test_processBitVector_nullClass() {
        Class empty = null;
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.processBitVector((Class)empty, (long)0L));
    }

    @Test
    public void test_processBitVectors() {
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{7L}));
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 7L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x80000000L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x100000000L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
    }

    @Test
    public void test_processBitVectors_longClass() {
        Assertions.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{7L}));
        Assertions.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
    }

    @Test
    public void test_processBitVectors_nullClass() {
        Class empty = null;
        Assertions.assertThrows(NullPointerException.class, () -> EnumUtils.processBitVectors((Class)empty, (long[])new long[]{0L}));
    }

    @Test
    public void testConstructable() {
        new EnumUtils();
    }
}

