/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ClassLoaderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassLoaderUtilsTest
extends AbstractLangTest {
    @Test
    public void testGetSystemURLs() {
        Assertions.assertNotNull((Object)ClassLoaderUtils.getSystemURLs());
    }

    @Test
    public void testGetThreadURLs() {
        Assertions.assertNotNull((Object)ClassLoaderUtils.getThreadURLs());
    }

    @Test
    public void testToString_ClassLoader() throws IOException {
        URL url = new URL("http://localhost");
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});){
            URLClassLoader classLoader = urlClassLoader;
            Assertions.assertEquals((Object)String.format("%s[%s]", classLoader, url), (Object)ClassLoaderUtils.toString((ClassLoader)classLoader));
        }
    }

    @Test
    public void testToString_URLClassLoader() throws IOException {
        URL url = new URL("http://localhost");
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});){
            Assertions.assertEquals((Object)String.format("%s[%s]", urlClassLoader, url), (Object)ClassLoaderUtils.toString((URLClassLoader)urlClassLoader));
        }
    }
}

