/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.CharEncoding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharEncodingTest
extends AbstractLangTest {
    private void assertSupportedEncoding(String name) {
        Assertions.assertTrue((boolean)CharEncoding.isSupported((String)name), (String)("Encoding should be supported: " + name));
    }

    @Test
    public void testConstructor() {
        new CharEncoding();
    }

    @Test
    public void testMustBeSupportedJava1_3_1_and_above() {
        this.assertSupportedEncoding("ISO-8859-1");
        this.assertSupportedEncoding("US-ASCII");
        this.assertSupportedEncoding("UTF-16");
        this.assertSupportedEncoding("UTF-16BE");
        this.assertSupportedEncoding("UTF-16LE");
        this.assertSupportedEncoding("UTF-8");
    }

    @Test
    public void testSupported() {
        Assertions.assertTrue((boolean)CharEncoding.isSupported((String)"UTF8"));
        Assertions.assertTrue((boolean)CharEncoding.isSupported((String)"UTF-8"));
        Assertions.assertTrue((boolean)CharEncoding.isSupported((String)"ASCII"));
    }

    @Test
    public void testNotSupported() {
        Assertions.assertFalse((boolean)CharEncoding.isSupported(null));
        Assertions.assertFalse((boolean)CharEncoding.isSupported((String)""));
        Assertions.assertFalse((boolean)CharEncoding.isSupported((String)" "));
        Assertions.assertFalse((boolean)CharEncoding.isSupported((String)"\t\r\n"));
        Assertions.assertFalse((boolean)CharEncoding.isSupported((String)"DOESNOTEXIST"));
        Assertions.assertFalse((boolean)CharEncoding.isSupported((String)"this is not a valid encoding name"));
    }

    @Test
    public void testStandardCharsetsEquality() {
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1.name(), (Object)"ISO-8859-1");
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)"US-ASCII");
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)"UTF-8");
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)"UTF-16");
        Assertions.assertEquals((Object)StandardCharsets.UTF_16BE.name(), (Object)"UTF-16BE");
        Assertions.assertEquals((Object)StandardCharsets.UTF_16LE.name(), (Object)"UTF-16LE");
    }
}

