/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.BitField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitFieldTest
extends AbstractLangTest {
    private static final BitField bf_multi = new BitField(16256);
    private static final BitField bf_single = new BitField(16384);
    private static final BitField bf_zero = new BitField(0);

    @Test
    public void testGetValue() {
        Assertions.assertEquals((int)bf_multi.getValue(-1), (int)127);
        Assertions.assertEquals((int)bf_multi.getValue(0), (int)0);
        Assertions.assertEquals((int)bf_single.getValue(-1), (int)1);
        Assertions.assertEquals((int)bf_single.getValue(0), (int)0);
        Assertions.assertEquals((int)bf_zero.getValue(-1), (int)0);
        Assertions.assertEquals((int)bf_zero.getValue(0), (int)0);
    }

    @Test
    public void testGetShortValue() {
        Assertions.assertEquals((short)bf_multi.getShortValue((short)-1), (short)127);
        Assertions.assertEquals((short)bf_multi.getShortValue((short)0), (short)0);
        Assertions.assertEquals((short)bf_single.getShortValue((short)-1), (short)1);
        Assertions.assertEquals((short)bf_single.getShortValue((short)0), (short)0);
        Assertions.assertEquals((short)bf_zero.getShortValue((short)-1), (short)0);
        Assertions.assertEquals((short)bf_zero.getShortValue((short)0), (short)0);
    }

    @Test
    public void testGetRawValue() {
        Assertions.assertEquals((int)bf_multi.getRawValue(-1), (int)16256);
        Assertions.assertEquals((int)bf_multi.getRawValue(0), (int)0);
        Assertions.assertEquals((int)bf_single.getRawValue(-1), (int)16384);
        Assertions.assertEquals((int)bf_single.getRawValue(0), (int)0);
        Assertions.assertEquals((int)bf_zero.getRawValue(-1), (int)0);
        Assertions.assertEquals((int)bf_zero.getRawValue(0), (int)0);
    }

    @Test
    public void testGetShortRawValue() {
        Assertions.assertEquals((short)bf_multi.getShortRawValue((short)-1), (short)16256);
        Assertions.assertEquals((short)bf_multi.getShortRawValue((short)0), (short)0);
        Assertions.assertEquals((short)bf_single.getShortRawValue((short)-1), (short)16384);
        Assertions.assertEquals((short)bf_single.getShortRawValue((short)0), (short)0);
        Assertions.assertEquals((short)bf_zero.getShortRawValue((short)-1), (short)0);
        Assertions.assertEquals((short)bf_zero.getShortRawValue((short)0), (short)0);
    }

    @Test
    public void testIsSet() {
        int j;
        Assertions.assertFalse((boolean)bf_multi.isSet(0));
        Assertions.assertFalse((boolean)bf_zero.isSet(0));
        for (j = 128; j <= 16256; j += 128) {
            Assertions.assertTrue((boolean)bf_multi.isSet(j));
        }
        for (j = 128; j <= 16256; j += 128) {
            Assertions.assertFalse((boolean)bf_zero.isSet(j));
        }
        Assertions.assertFalse((boolean)bf_single.isSet(0));
        Assertions.assertTrue((boolean)bf_single.isSet(16384));
    }

    @Test
    public void testIsAllSet() {
        for (int j = 0; j < 16256; j += 128) {
            Assertions.assertFalse((boolean)bf_multi.isAllSet(j));
            Assertions.assertTrue((boolean)bf_zero.isAllSet(j));
        }
        Assertions.assertTrue((boolean)bf_multi.isAllSet(16256));
        Assertions.assertFalse((boolean)bf_single.isAllSet(0));
        Assertions.assertTrue((boolean)bf_single.isAllSet(16384));
    }

    @Test
    public void testSetValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            Assertions.assertEquals((int)bf_multi.getValue(bf_multi.setValue(0, j)), (int)j);
            Assertions.assertEquals((int)bf_multi.setValue(0, j), (int)(j << 7));
        }
        for (j = 0; j < 128; ++j) {
            Assertions.assertEquals((int)bf_zero.getValue(bf_zero.setValue(0, j)), (int)0);
            Assertions.assertEquals((int)bf_zero.setValue(0, j), (int)0);
        }
        Assertions.assertEquals((int)bf_multi.setValue(16256, 128), (int)0);
        for (j = 0; j < 2; ++j) {
            Assertions.assertEquals((int)bf_single.getValue(bf_single.setValue(0, j)), (int)j);
            Assertions.assertEquals((int)bf_single.setValue(0, j), (int)(j << 14));
        }
        Assertions.assertEquals((int)bf_single.setValue(16384, 2), (int)0);
    }

    @Test
    public void testSetShortValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            Assertions.assertEquals((short)bf_multi.getShortValue(bf_multi.setShortValue((short)0, (short)j)), (short)((short)j));
            Assertions.assertEquals((short)bf_multi.setShortValue((short)0, (short)j), (short)((short)(j << 7)));
        }
        for (j = 0; j < 128; ++j) {
            Assertions.assertEquals((short)bf_zero.getShortValue(bf_zero.setShortValue((short)0, (short)j)), (short)0);
            Assertions.assertEquals((short)bf_zero.setShortValue((short)0, (short)j), (short)0);
        }
        Assertions.assertEquals((short)bf_multi.setShortValue((short)16256, (short)128), (short)0);
        for (j = 0; j < 2; ++j) {
            Assertions.assertEquals((short)bf_single.getShortValue(bf_single.setShortValue((short)0, (short)j)), (short)((short)j));
            Assertions.assertEquals((short)bf_single.setShortValue((short)0, (short)j), (short)((short)(j << 14)));
        }
        Assertions.assertEquals((short)bf_single.setShortValue((short)16384, (short)2), (short)0);
    }

    @Test
    public void testByte() {
        Assertions.assertEquals((int)0, (int)new BitField(0).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)1, (int)new BitField(1).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)2, (int)new BitField(2).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)4, (int)new BitField(4).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)8, (int)new BitField(8).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)16, (int)new BitField(16).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)32, (int)new BitField(32).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)64, (int)new BitField(64).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)-128, (int)new BitField(128).setByteBoolean((byte)0, true));
        Assertions.assertEquals((int)1, (int)new BitField(0).setByteBoolean((byte)1, false));
        Assertions.assertEquals((int)0, (int)new BitField(1).setByteBoolean((byte)1, false));
        Assertions.assertEquals((int)0, (int)new BitField(2).setByteBoolean((byte)2, false));
        Assertions.assertEquals((int)0, (int)new BitField(4).setByteBoolean((byte)4, false));
        Assertions.assertEquals((int)0, (int)new BitField(8).setByteBoolean((byte)8, false));
        Assertions.assertEquals((int)0, (int)new BitField(16).setByteBoolean((byte)16, false));
        Assertions.assertEquals((int)0, (int)new BitField(32).setByteBoolean((byte)32, false));
        Assertions.assertEquals((int)0, (int)new BitField(64).setByteBoolean((byte)64, false));
        Assertions.assertEquals((int)0, (int)new BitField(128).setByteBoolean((byte)-128, false));
        Assertions.assertEquals((int)-2, (int)new BitField(1).setByteBoolean((byte)-1, false));
        byte clearedBit = new BitField(64).setByteBoolean((byte)-63, false);
        Assertions.assertFalse((boolean)new BitField(64).isSet((int)clearedBit));
    }

    @Test
    public void testClear() {
        Assertions.assertEquals((int)bf_multi.clear(-1), (int)-16257);
        Assertions.assertEquals((int)bf_single.clear(-1), (int)-16385);
        Assertions.assertEquals((int)bf_zero.clear(-1), (int)-1);
    }

    @Test
    public void testClearShort() {
        Assertions.assertEquals((short)bf_multi.clearShort((short)-1), (short)-16257);
        Assertions.assertEquals((short)bf_single.clearShort((short)-1), (short)-16385);
        Assertions.assertEquals((short)bf_zero.clearShort((short)-1), (short)-1);
    }

    @Test
    public void testSet() {
        Assertions.assertEquals((int)bf_multi.set(0), (int)16256);
        Assertions.assertEquals((int)bf_single.set(0), (int)16384);
        Assertions.assertEquals((int)bf_zero.set(0), (int)0);
    }

    @Test
    public void testSetShort() {
        Assertions.assertEquals((short)bf_multi.setShort((short)0), (short)16256);
        Assertions.assertEquals((short)bf_single.setShort((short)0), (short)16384);
        Assertions.assertEquals((short)bf_zero.setShort((short)0), (short)0);
    }

    @Test
    public void testSetBoolean() {
        Assertions.assertEquals((int)bf_multi.set(0), (int)bf_multi.setBoolean(0, true));
        Assertions.assertEquals((int)bf_single.set(0), (int)bf_single.setBoolean(0, true));
        Assertions.assertEquals((int)bf_zero.set(0), (int)bf_zero.setBoolean(0, true));
        Assertions.assertEquals((int)bf_multi.clear(-1), (int)bf_multi.setBoolean(-1, false));
        Assertions.assertEquals((int)bf_single.clear(-1), (int)bf_single.setBoolean(-1, false));
        Assertions.assertEquals((int)bf_zero.clear(-1), (int)bf_zero.setBoolean(-1, false));
    }

    @Test
    public void testSetShortBoolean() {
        Assertions.assertEquals((short)bf_multi.setShort((short)0), (short)bf_multi.setShortBoolean((short)0, true));
        Assertions.assertEquals((short)bf_single.setShort((short)0), (short)bf_single.setShortBoolean((short)0, true));
        Assertions.assertEquals((short)bf_zero.setShort((short)0), (short)bf_zero.setShortBoolean((short)0, true));
        Assertions.assertEquals((short)bf_multi.clearShort((short)-1), (short)bf_multi.setShortBoolean((short)-1, false));
        Assertions.assertEquals((short)bf_single.clearShort((short)-1), (short)bf_single.setShortBoolean((short)-1, false));
        Assertions.assertEquals((short)bf_zero.clearShort((short)-1), (short)bf_zero.setShortBoolean((short)-1, false));
    }
}

