/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableBooleanTest {
    @Test
    public void testCompareTo() {
        MutableBoolean mutBool = new MutableBoolean(false);
        Assertions.assertEquals((int)0, (int)mutBool.compareTo(new MutableBoolean(false)));
        Assertions.assertEquals((int)-1, (int)mutBool.compareTo(new MutableBoolean(true)));
        mutBool.setValue(true);
        Assertions.assertEquals((int)1, (int)mutBool.compareTo(new MutableBoolean(false)));
        Assertions.assertEquals((int)0, (int)mutBool.compareTo(new MutableBoolean(true)));
    }

    @Test
    public void testCompareToNull() {
        MutableBoolean mutBool = new MutableBoolean(false);
        Assertions.assertThrows(NullPointerException.class, () -> mutBool.compareTo(null));
    }

    @Test
    public void testConstructorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MutableBoolean(null));
    }

    @Test
    public void testConstructors() {
        Assertions.assertFalse((boolean)new MutableBoolean().booleanValue());
        Assertions.assertTrue((boolean)new MutableBoolean(true).booleanValue());
        Assertions.assertFalse((boolean)new MutableBoolean(false).booleanValue());
        Assertions.assertTrue((boolean)new MutableBoolean(Boolean.TRUE).booleanValue());
        Assertions.assertFalse((boolean)new MutableBoolean(Boolean.FALSE).booleanValue());
    }

    @Test
    public void testEquals() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        Assertions.assertEquals((Object)mutBoolA, (Object)mutBoolA);
        Assertions.assertEquals((Object)mutBoolA, (Object)mutBoolB);
        Assertions.assertEquals((Object)mutBoolB, (Object)mutBoolA);
        Assertions.assertEquals((Object)mutBoolB, (Object)mutBoolB);
        Assertions.assertNotEquals((Object)mutBoolA, (Object)mutBoolC);
        Assertions.assertNotEquals((Object)mutBoolB, (Object)mutBoolC);
        Assertions.assertEquals((Object)mutBoolC, (Object)mutBoolC);
        Assertions.assertNotEquals(null, (Object)mutBoolA);
        Assertions.assertNotEquals((Object)mutBoolA, (Object)Boolean.FALSE);
        Assertions.assertNotEquals((Object)"false", (Object)mutBoolA);
    }

    @Test
    public void testGetSet() {
        Assertions.assertFalse((boolean)new MutableBoolean().booleanValue());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)new MutableBoolean().getValue());
        MutableBoolean mutBool = new MutableBoolean(false);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)mutBool.toBoolean());
        Assertions.assertFalse((boolean)mutBool.booleanValue());
        Assertions.assertTrue((boolean)mutBool.isFalse());
        Assertions.assertFalse((boolean)mutBool.isTrue());
        mutBool.setValue(Boolean.TRUE);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)mutBool.toBoolean());
        Assertions.assertTrue((boolean)mutBool.booleanValue());
        Assertions.assertFalse((boolean)mutBool.isFalse());
        Assertions.assertTrue((boolean)mutBool.isTrue());
        mutBool.setValue(false);
        Assertions.assertFalse((boolean)mutBool.booleanValue());
        mutBool.setValue(true);
        Assertions.assertTrue((boolean)mutBool.booleanValue());
        mutBool.setFalse();
        Assertions.assertFalse((boolean)mutBool.booleanValue());
        mutBool.setTrue();
        Assertions.assertTrue((boolean)mutBool.booleanValue());
    }

    @Test
    public void testHashCode() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        Assertions.assertEquals((int)mutBoolA.hashCode(), (int)mutBoolA.hashCode());
        Assertions.assertEquals((int)mutBoolA.hashCode(), (int)mutBoolB.hashCode());
        Assertions.assertNotEquals((int)mutBoolA.hashCode(), (int)mutBoolC.hashCode());
        Assertions.assertEquals((int)mutBoolA.hashCode(), (int)Boolean.FALSE.hashCode());
        Assertions.assertEquals((int)mutBoolC.hashCode(), (int)Boolean.TRUE.hashCode());
    }

    @Test
    public void testSetNull() {
        MutableBoolean mutBool = new MutableBoolean(false);
        Assertions.assertThrows(NullPointerException.class, () -> mutBool.setValue(null));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)new MutableBoolean(false).toString());
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)new MutableBoolean(true).toString());
    }
}

