/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableSupplier;

public class Objects {
    @Nonnull
    public static <T> T requireNonNull(@Nullable T value) throws NullPointerException {
        return Objects.requireNonNull(value, "The value must not be null.");
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T value, @Nonnull T defaultValue) throws NullPointerException {
        return value == null ? Objects.requireNonNull(defaultValue) : value;
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T value, @Nonnull String msg) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        return value;
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T value, @Nonnull Supplier<String> msgSupplier) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException(msgSupplier.get());
        }
        return value;
    }

    @Nonnull
    public static <T, E extends Throwable> T requireNonNull(@Nullable T value, @Nonnull FailableSupplier<T, E> defaultValueSupplier) throws NullPointerException {
        if (value == null) {
            Object defaultValue;
            FailableSupplier<T, E> supplier = Objects.requireNonNull(defaultValueSupplier, "The supplier must not be null");
            try {
                defaultValue = supplier.get();
            }
            catch (Throwable t) {
                throw Failable.rethrow((Throwable)t);
            }
            return (T)Objects.requireNonNull(defaultValue, "The supplier must not return null.");
        }
        return value;
    }
}

