/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StandardToStringStyleTest {
    private final Integer base = 5;
    private final String baseStr = "Integer";
    private static final StandardToStringStyle STYLE = new StandardToStringStyle();

    @BeforeEach
    public void setUp() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)STYLE);
    }

    @AfterEach
    public void tearDown() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testBlank() {
        Assertions.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testAppendSuper() {
        Assertions.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").toString());
        Assertions.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"Integer[%NULL%,a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(null).toString());
        Assertions.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assertions.assertEquals((Object)"Integer[a=%NULL%]", (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assertions.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assertions.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assertions.assertEquals((Object)"Integer[a=%Integer%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
    }

    @Test
    public void testCollection() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3]]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=2%]", (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3, 4]]", (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), true).toString());
    }

    @Test
    public void testMap() {
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), false).toString());
        Assertions.assertEquals((Object)"Integer[a={}]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), false).toString());
        Assertions.assertEquals((Object)"Integer[a={k=v}]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), true).toString());
    }

    @Test
    public void testArray() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], false).toString());
        Assertions.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=2%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3, 4]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, true).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Suzy Queue";
        p.age = 19;
        p.smoker = false;
        String pBaseStr = "ToStringStyleTest.Person";
        Assertions.assertEquals((Object)"ToStringStyleTest.Person[name=Suzy Queue,age=19,smoker=false]", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    public void testLong() {
        Assertions.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assertions.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assertions.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        Assertions.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testDefaultValueOfUseClassName() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseClassName());
    }

    @Test
    public void testDefaultValueOfUseFieldNames() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseFieldNames());
    }

    @Test
    public void testDefaultValueOfUseShortClassName() {
        Assertions.assertFalse((boolean)new StandardToStringStyle().isUseShortClassName());
    }

    @Test
    public void testDefaultValueOfUseIdentityHashCode() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseIdentityHashCode());
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
        STYLE.setArrayStart("[");
        STYLE.setArraySeparator(", ");
        STYLE.setArrayEnd("]");
        STYLE.setNullText("%NULL%");
        STYLE.setSizeStartText("%SIZE=");
        STYLE.setSizeEndText("%");
        STYLE.setSummaryObjectStartText("%");
        STYLE.setSummaryObjectEndText("%");
    }
}

