/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CharSequenceUtilsTest {
    private static final TestData[] TEST_DATA = new TestData[]{new TestData("", true, -1, "", -1, -1, false), new TestData("", true, 0, "", 0, 1, false), new TestData("a", true, 0, "abc", 0, 0, true), new TestData("a", true, 0, "abc", 0, 1, true), new TestData("a", true, 0, null, 0, 0, NullPointerException.class), new TestData(null, true, 0, null, 0, 0, NullPointerException.class), new TestData(null, true, 0, "", 0, 0, NullPointerException.class), new TestData("Abc", true, 0, "abc", 0, 3, true), new TestData("Abc", false, 0, "abc", 0, 3, false), new TestData("Abc", true, 1, "abc", 1, 2, true), new TestData("Abc", false, 1, "abc", 1, 2, true), new TestData("Abcd", true, 1, "abcD", 1, 2, true), new TestData("Abcd", false, 1, "abcD", 1, 2, true)};

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new CharSequenceUtils());
        Constructor<?>[] cons = CharSequenceUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(CharSequenceUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(CharSequenceUtils.class.getModifiers()));
    }

    @Test
    public void testSubSequence() {
        Assertions.assertNull((Object)CharSequenceUtils.subSequence(null, (int)-1));
        Assertions.assertNull((Object)CharSequenceUtils.subSequence(null, (int)0));
        Assertions.assertNull((Object)CharSequenceUtils.subSequence(null, (int)1));
        Assertions.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)0));
        Assertions.assertEquals((Object)"012", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)0));
        Assertions.assertEquals((Object)"12", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)1));
        Assertions.assertEquals((Object)"2", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)2));
        Assertions.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)3));
    }

    @Test
    public void testSubSequenceNegativeStart() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CharSequenceUtils.subSequence((CharSequence)"", (int)-1));
    }

    @Test
    public void testSubSequenceTooLong() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CharSequenceUtils.subSequence((CharSequence)"", (int)1));
    }

    @Test
    public void testRegionMatches() {
        for (final TestData data : TEST_DATA) {
            new RunTest(){

                @Override
                boolean invoke() {
                    return data.source.regionMatches(data.ignoreCase, data.toffset, data.other, data.ooffset, data.len);
                }
            }.run(data, "String");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)data.source, (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSString");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)new StringBuilder(data.source), (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSNonString");
        }
    }

    @Test
    public void testToCharArray() {
        StringBuilder builder = new StringBuilder("abcdefg");
        char[] expected = builder.toString().toCharArray();
        Assertions.assertArrayEquals((char[])expected, (char[])CharSequenceUtils.toCharArray((CharSequence)builder));
        Assertions.assertArrayEquals((char[])expected, (char[])CharSequenceUtils.toCharArray((CharSequence)builder.toString()));
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])CharSequenceUtils.toCharArray(null));
    }

    @Test
    public void testNewLastIndexOf() {
        this.testNewLastIndexOfSingle("808087847-1321060740-635567660180086727-925755305", "-1321060740-635567660", 21);
        this.testNewLastIndexOfSingle("", "");
        this.testNewLastIndexOfSingle("1", "");
        this.testNewLastIndexOfSingle("", "1");
        this.testNewLastIndexOfSingle("1", "1");
        this.testNewLastIndexOfSingle("11", "1");
        this.testNewLastIndexOfSingle("1", "11");
        this.testNewLastIndexOfSingle("apache", "a");
        this.testNewLastIndexOfSingle("apache", "p");
        this.testNewLastIndexOfSingle("apache", "e");
        this.testNewLastIndexOfSingle("apache", "x");
        this.testNewLastIndexOfSingle("oraoraoraora", "r");
        this.testNewLastIndexOfSingle("mudamudamudamuda", "d");
        Random random = new Random();
        StringBuilder seg = new StringBuilder();
        while (seg.length() <= 16) {
            seg.append(random.nextInt());
        }
        StringBuilder original = new StringBuilder(seg);
        this.testNewLastIndexOfSingle(original, seg);
        for (int i = 0; i < 100; ++i) {
            if (random.nextDouble() < 0.5) {
                original.append(random.nextInt() % 10);
            } else {
                original = new StringBuilder().append(String.valueOf(random.nextInt() % 100)).append((CharSequence)original);
            }
            this.testNewLastIndexOfSingle(original, seg);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"lastIndexWithStandardCharSequence"})
    public void testLastIndexOfWithDifferentCharSequences(CharSequence cs, CharSequence search, int start, int expected) {
        Assertions.assertEquals((int)expected, (int)CharSequenceUtils.lastIndexOf((CharSequence)cs, (CharSequence)search, (int)start));
    }

    static Stream<Arguments> lastIndexWithStandardCharSequence() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"abc", "b", 2, 1}), Arguments.arguments((Object[])new Object[]{new StringBuilder("abc"), "b", 2, 1}), Arguments.arguments((Object[])new Object[]{new StringBuffer("abc"), "b", 2, 1}), Arguments.arguments((Object[])new Object[]{"abc", new StringBuilder("b"), 2, 1}), Arguments.arguments((Object[])new Object[]{new StringBuilder("abc"), new StringBuilder("b"), 2, 1}), Arguments.arguments((Object[])new Object[]{new StringBuffer("abc"), new StringBuffer("b"), 2, 1}), Arguments.arguments((Object[])new Object[]{new StringBuilder("abc"), new StringBuffer("b"), 2, 1}));
    }

    private void testNewLastIndexOfSingle(CharSequence a, CharSequence b) {
        int maxa = Math.max(a.length(), b.length());
        for (int i = -maxa - 10; i <= maxa + 10; ++i) {
            this.testNewLastIndexOfSingle(a, b, i);
        }
        this.testNewLastIndexOfSingle(a, b, Integer.MIN_VALUE);
        this.testNewLastIndexOfSingle(a, b, Integer.MAX_VALUE);
    }

    private void testNewLastIndexOfSingle(CharSequence a, CharSequence b, int start) {
        this.testNewLastIndexOfSingleSingle(a, b, start);
        this.testNewLastIndexOfSingleSingle(b, a, start);
    }

    private void testNewLastIndexOfSingleSingle(CharSequence a, CharSequence b, int start) {
        Assertions.assertEquals((int)a.toString().lastIndexOf(b.toString(), start), (int)CharSequenceUtils.lastIndexOf((CharSequence)new WrapperString(a.toString()), (CharSequence)new WrapperString(b.toString()), (int)start), (String)("testNewLastIndexOf fails! original : " + a + " seg : " + b + " start : " + start));
    }

    static class WrapperString
    implements CharSequence {
        private final CharSequence inner;

        WrapperString(CharSequence inner) {
            this.inner = inner;
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public char charAt(int index) {
            return this.inner.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.inner.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }

        @Override
        public IntStream chars() {
            return this.inner.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.inner.codePoints();
        }
    }

    private static abstract class RunTest {
        private RunTest() {
        }

        abstract boolean invoke();

        void run(TestData data, String id) {
            if (data.throwable != null) {
                Assertions.assertThrows(data.throwable, this::invoke, (String)(id + " Expected " + data.throwable));
            } else {
                boolean stringCheck = this.invoke();
                Assertions.assertEquals((Object)data.expected, (Object)stringCheck, (String)(id + " Failed test " + data));
            }
        }
    }

    static class TestData {
        final String source;
        final boolean ignoreCase;
        final int toffset;
        final String other;
        final int ooffset;
        final int len;
        final boolean expected;
        final Class<? extends Throwable> throwable;

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, boolean expected) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = expected;
            this.throwable = null;
        }

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, Class<? extends Throwable> throwable) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = false;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.source).append("[").append(this.toffset).append("]");
            sb.append(this.ignoreCase ? " caseblind " : " samecase ");
            sb.append(this.other).append("[").append(this.ooffset).append("]");
            sb.append(" ").append(this.len).append(" => ");
            if (this.throwable != null) {
                sb.append(this.throwable);
            } else {
                sb.append(this.expected);
            }
            return sb.toString();
        }
    }
}

