/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.AssertionFailedError;
import org.apache.commons.jelly.LocationAware;

public class JellyAssertionFailedError
extends AssertionFailedError
implements LocationAware {
    private Throwable cause;
    private String fileName;
    private String elementName;
    private int lineNumber = -1;
    private int columnNumber = -1;

    public JellyAssertionFailedError() {
    }

    public JellyAssertionFailedError(String message) {
        super(message);
    }

    public JellyAssertionFailedError(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public JellyAssertionFailedError(Throwable cause) {
        super(cause.getLocalizedMessage());
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getMessage() {
        return this.fileName + ":" + this.lineNumber + ":" + this.columnNumber + ": <" + this.elementName + "> " + super.getMessage();
    }

    public String getReason() {
        return super.getMessage();
    }

    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.cause != null) {
                s.println("Root cause");
                this.cause.printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.cause != null) {
                s.println("Root cause");
                this.cause.printStackTrace(s);
            }
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            System.out.println("Root cause");
            this.cause.printStackTrace();
        }
    }
}

