/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadTextTag
extends TagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$util$LoadTextTag == null ? (class$org$apache$commons$jelly$tags$util$LoadTextTag = LoadTextTag.class$("org.apache.commons.jelly.tags.util.LoadTextTag")) : class$org$apache$commons$jelly$tags$util$LoadTextTag));
    private String var;
    private File file;
    private String uri;
    private String encoding;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$util$LoadTextTag;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.var == null) {
            throw new MissingAttributeException("var");
        }
        if (this.file == null && this.uri == null) {
            throw new JellyTagException("This tag must have a 'file' or 'uri' specified");
        }
        InputStream in = null;
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new JellyTagException("The file: " + this.file + " does not exist");
            }
            try {
                in = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new JellyTagException("could not find the file", (Throwable)e);
            }
        } else {
            in = this.context.getResourceAsStream(this.uri);
            if (in == null) {
                throw new JellyTagException("Could not find uri: " + this.uri);
            }
        }
        InputStreamReader reader = null;
        if (this.encoding != null) {
            try {
                reader = new InputStreamReader(in, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new JellyTagException("unsupported encoding", (Throwable)e);
            }
        } else {
            reader = new InputStreamReader(in);
        }
        String text = null;
        try {
            text = this.loadText(reader);
        }
        catch (IOException e) {
            throw new JellyTagException((Throwable)e);
        }
        this.context.setVariable(this.var, (Object)text);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public File getFile() {
        return this.file;
    }

    public String getUri() {
        return this.uri;
    }

    public String getVar() {
        return this.var;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected String loadText(Reader reader) throws IOException {
        String string;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            string = buffer.toString();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                reader.close();
            }
            catch (Exception e) {
                log.error((Object)("Caught exception closing Reader: " + e), (Throwable)e);
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            log.error((Object)("Caught exception closing Reader: " + e), (Throwable)e);
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

