/*
 * Decompiled with CFR 0.152.
 */
package com.werken.forehead;

import com.werken.forehead.ForeheadClassLoader;
import com.werken.forehead.ForeheadException;
import com.werken.forehead.MalformedEntryDescriptorException;
import com.werken.forehead.NoEntryDescriptorException;
import com.werken.forehead.NoSuchClassLoaderException;
import com.werken.forehead.NoSuchEntryMethodException;
import com.werken.forehead.NoSuchPropertyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Forehead {
    private static final Forehead INSTANCE = new Forehead();
    private Map classLoaders = new HashMap();
    private ForeheadClassLoader rootLoader;
    private ForeheadClassLoader entryLoader;
    private Class entryClass;
    private Method entryMethod;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void config(InputStream in) throws ForeheadException, IOException, ClassNotFoundException {
        this.config(new BufferedReader(new InputStreamReader(in)));
    }

    public void config(Reader in) throws ForeheadException, IOException, ClassNotFoundException {
        if (in instanceof BufferedReader) {
            this.config(in);
        } else {
            this.config(new BufferedReader(in));
        }
    }

    public void config(BufferedReader in) throws ForeheadException, IOException, ClassNotFoundException {
        this.rootLoader = new ForeheadClassLoader(this.getClass().getClassLoader(), "$forehead-root$");
        String line = null;
        ForeheadClassLoader currentLoader = this.rootLoader;
        Properties props = new Properties();
        String entryLine = null;
        while ((line = in.readLine()) != null) {
            if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
            if (line.startsWith("+")) {
                String propName = line.substring(1);
                String propValue = System.getProperty(propName);
                if (propValue == null) {
                    throw new NoSuchPropertyException(propName);
                }
                props.setProperty(propName, propValue);
                continue;
            }
            if (line.startsWith("=")) {
                entryLine = line;
                continue;
            }
            ForeheadClassLoader parentLoader = null;
            if (line.startsWith("[") && line.endsWith("]")) {
                String loaderName = line.substring(1, line.length() - 1);
                int dotLoc = loaderName.lastIndexOf(".");
                if (dotLoc > 0) {
                    String parentName = loaderName.substring(0, dotLoc);
                    parentLoader = this.getClassLoader(parentName);
                    if (parentLoader == null) {
                        throw new NoSuchClassLoaderException(parentName);
                    }
                } else {
                    parentLoader = this.rootLoader;
                }
                currentLoader = this.createClassLoader(parentLoader, loaderName);
                continue;
            }
            String resolvedLine = this.resolveProperties(line, props);
            this.load(resolvedLine, currentLoader);
        }
        if (entryLine == null) {
            throw new NoEntryDescriptorException();
        }
        this.setupEntry(entryLine);
    }

    protected void setupEntry(String line) throws MalformedEntryDescriptorException, NoSuchClassLoaderException, ClassNotFoundException {
        int leftBrackLoc = line.indexOf("[");
        if (leftBrackLoc < 0) {
            throw new MalformedEntryDescriptorException(line);
        }
        int rightBrackLoc = line.indexOf("]", leftBrackLoc + 1);
        if (rightBrackLoc < 0) {
            throw new MalformedEntryDescriptorException(line);
        }
        String loaderName = line.substring(leftBrackLoc + 1, rightBrackLoc);
        String className = line.substring(rightBrackLoc + 1).trim();
        this.entryLoader = this.getClassLoader(loaderName);
        if (this.entryLoader == null) {
            throw new NoSuchClassLoaderException(loaderName);
        }
        this.entryClass = Class.forName(className, true, this.entryLoader);
    }

    protected void load(String line, ForeheadClassLoader loader) throws MalformedURLException {
        if (line.indexOf("*") >= 0) {
            this.loadGlob(line, loader);
        } else {
            this.loadFileOrUrl(line, loader);
        }
    }

    protected void loadGlob(String line, ForeheadClassLoader loader) throws MalformedURLException {
        File globFile = new File(line);
        File dir = globFile.getParentFile();
        String localName = globFile.getName();
        int starLoc = localName.indexOf("*");
        final String prefix = localName.substring(0, starLoc);
        final String suffix = localName.substring(starLoc + 1);
        File[] matches = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (prefix != null && !name.startsWith(prefix)) {
                    return false;
                }
                return suffix == null || name.endsWith(suffix);
            }
        });
        for (int i = 0; i < matches.length; ++i) {
            loader.addURL(matches[i].toURL());
        }
    }

    protected void loadFileOrUrl(String line, ForeheadClassLoader loader) throws MalformedURLException {
        URL url = null;
        File file = new File(line);
        if (file.exists()) {
            url = file.toURL();
        } else {
            try {
                url = new URL(line);
            }
            catch (MalformedURLException mue) {
                System.err.println("File or url '" + line + "' could not be found");
                throw mue;
            }
        }
        loader.addURL(url);
    }

    protected ForeheadClassLoader createClassLoader(ForeheadClassLoader parent, String name) {
        ForeheadClassLoader loader = new ForeheadClassLoader(parent, name);
        this.classLoaders.put(name, loader);
        return loader;
    }

    public ForeheadClassLoader getClassLoader(String name) {
        return (ForeheadClassLoader)this.classLoaders.get(name);
    }

    public String resolveProperties(String input, Properties props) {
        String output = "";
        int cur = 0;
        int prefixLoc = 0;
        int suffixLoc = 0;
        while (cur < input.length() && (prefixLoc = input.indexOf("${", cur)) >= 0) {
            suffixLoc = input.indexOf("}", prefixLoc);
            String propName = input.substring(prefixLoc + 2, suffixLoc);
            output = output + input.substring(cur, prefixLoc);
            output = output + props.getProperty(propName);
            cur = suffixLoc + 1;
        }
        output = output + input.substring(cur);
        return output;
    }

    public void run(String[] args) throws NoSuchEntryMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods = this.entryClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            int modifiers;
            if (!"main".equals(methods[i].getName()) || !Modifier.isStatic(modifiers = methods[i].getModifiers()) || !Modifier.isPublic(modifiers) || methods[i].getReturnType() != Void.TYPE || (paramTypes = methods[i].getParameterTypes()).length != 1 || paramTypes[0] != (array$Ljava$lang$String == null ? Forehead.class$("[Ljava.lang.String;") : array$Ljava$lang$String)) continue;
            this.entryMethod = methods[i];
            break;
        }
        if (this.entryMethod == null) {
            throw new NoSuchEntryMethodException(this.entryClass, "public static void main(String[] args)");
        }
        Thread.currentThread().setContextClassLoader(this.entryLoader);
        this.entryMethod.invoke((Object)this.entryClass, new Object[]{args});
    }

    public static Forehead getInstance() {
        return INSTANCE;
    }

    public static void main(String[] args) {
        String confFileName = System.getProperty("forehead.conf.file");
        File confFile = new File(confFileName);
        Forehead forehead = Forehead.getInstance();
        try {
            forehead.config(new FileInputStream(confFile));
            forehead.run(args);
        }
        catch (NoSuchEntryMethodException e) {
            System.err.println("No method on class " + e.getEntryClass() + " matching: " + e.getEntryMethodDescriptor());
            e.printStackTrace();
        }
        catch (ForeheadException e) {
            System.err.println("Error during configuration: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Error reading configuration: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

