/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.xpath.XPathExpression;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.junit.AssertEqualsTag;
import org.apache.commons.jelly.tags.junit.AssertTag;
import org.apache.commons.jelly.tags.junit.AssertThrowsTag;
import org.apache.commons.jelly.tags.junit.CaseTag;
import org.apache.commons.jelly.tags.junit.FailTag;
import org.apache.commons.jelly.tags.junit.RunTag;
import org.apache.commons.jelly.tags.junit.SuiteTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JUnitTagLibrary
extends TagLibrary {
    private Log log = LogFactory.getLog(JUnitTagLibrary.class);

    public JUnitTagLibrary() {
        this.registerTag("assert", AssertTag.class);
        this.registerTag("assertEquals", AssertEqualsTag.class);
        this.registerTag("assertThrows", AssertThrowsTag.class);
        this.registerTag("fail", FailTag.class);
        this.registerTag("run", RunTag.class);
        this.registerTag("case", CaseTag.class);
        this.registerTag("suite", SuiteTag.class);
    }

    public Expression createExpression(ExpressionFactory factory, TagScript tagScript, String attributeName, String attributeValue) throws JellyException {
        if (attributeName.equals("xpath")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parsing XPath expression: " + attributeValue));
            }
            Expression xpathExpr = super.createExpression(factory, tagScript, attributeName, attributeValue);
            return new XPathExpression(attributeValue, xpathExpr, tagScript);
        }
        return super.createExpression(factory, tagScript, attributeName, attributeValue);
    }
}

