/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoverySenderUnitTest
extends TestCase {
    private static final String ADDRESS = "228.4.5.9";
    private static final int PORT = 5556;
    private static final String SENDING_HOST = "imaginary host address";
    private static final int SENDING_PORT = 1;
    private UDPDiscoveryReceiver receiver;
    private UDPDiscoverySender sender;

    protected void setUp() throws Exception {
        super.setUp();
        this.receiver = new UDPDiscoveryReceiver(null, null, ADDRESS, 5556);
        this.receiver.setSerializer((IElementSerializer)new StandardSerializer());
        Thread t = new Thread((Runnable)this.receiver);
        t.start();
        this.sender = new UDPDiscoverySender(null, ADDRESS, 5556, 1, (IElementSerializer)new StandardSerializer());
    }

    protected void tearDown() throws Exception {
        this.receiver.shutdown();
        this.sender.close();
        super.tearDown();
    }

    public void testPassiveBroadcast() throws Exception {
        ArrayList cacheNames = new ArrayList();
        this.sender.passiveBroadcast(SENDING_HOST, 1, cacheNames, 1L);
        Object obj = this.receiver.waitForMessage();
        UDPDiscoverySenderUnitTest.assertTrue((String)"unexpected crap received", (boolean)(obj instanceof UDPDiscoveryMessage));
        UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
        UDPDiscoverySenderUnitTest.assertEquals((String)"wrong port", (int)1, (int)msg.getPort());
        UDPDiscoverySenderUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.PASSIVE, (Object)msg.getMessageType());
    }

    public void testRemoveBroadcast() throws Exception {
        ArrayList cacheNames = new ArrayList();
        this.sender.removeBroadcast(SENDING_HOST, 1, cacheNames, 1L);
        Object obj = this.receiver.waitForMessage();
        UDPDiscoverySenderUnitTest.assertTrue((String)"unexpected crap received", (boolean)(obj instanceof UDPDiscoveryMessage));
        UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
        UDPDiscoverySenderUnitTest.assertEquals((String)"wrong port", (int)1, (int)msg.getPort());
        UDPDiscoverySenderUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.REMOVE, (Object)msg.getMessageType());
    }

    public void testRequestBroadcast() throws Exception {
        this.sender.requestBroadcast();
        Object obj = this.receiver.waitForMessage();
        UDPDiscoverySenderUnitTest.assertTrue((String)"unexpected crap received", (boolean)(obj instanceof UDPDiscoveryMessage));
        UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
        UDPDiscoverySenderUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.REQUEST, (Object)msg.getMessageType());
    }
}

