/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.serialization.EncryptingSerializer;

public class UDPDiscoverySenderEncryptedUnitTest
extends TestCase {
    private static final String ADDRESS = "228.4.5.9";
    private static final int PORT = 5556;
    private static final String SENDING_HOST = "imaginary host address";
    private static final int SENDING_PORT = 1;
    private UDPDiscoveryReceiver receiver;
    private UDPDiscoverySender sender;

    protected void setUp() throws Exception {
        super.setUp();
        EncryptingSerializer serializer = new EncryptingSerializer();
        serializer.setPreSharedKey("my_key");
        this.receiver = new UDPDiscoveryReceiver(null, null, ADDRESS, 5556);
        this.receiver.setSerializer((IElementSerializer)serializer);
        Thread t = new Thread((Runnable)this.receiver);
        t.start();
        this.sender = new UDPDiscoverySender(null, ADDRESS, 5556, 1, (IElementSerializer)serializer);
    }

    protected void tearDown() throws Exception {
        this.receiver.shutdown();
        this.sender.close();
        super.tearDown();
    }

    public void testPassiveBroadcast() throws Exception {
        ArrayList cacheNames = new ArrayList();
        this.sender.passiveBroadcast(SENDING_HOST, 1, cacheNames, 1L);
        UDPDiscoveryMessage msg = this.getMessage();
        UDPDiscoverySenderEncryptedUnitTest.assertNotNull((String)"message not received", (Object)msg);
        UDPDiscoverySenderEncryptedUnitTest.assertEquals((String)"wrong port", (int)1, (int)msg.getPort());
        UDPDiscoverySenderEncryptedUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.PASSIVE, (Object)msg.getMessageType());
    }

    public void testRemoveBroadcast() throws Exception {
        ArrayList cacheNames = new ArrayList();
        this.sender.removeBroadcast(SENDING_HOST, 1, cacheNames, 1L);
        UDPDiscoveryMessage msg = this.getMessage();
        UDPDiscoverySenderEncryptedUnitTest.assertNotNull((String)"message not received", (Object)msg);
        UDPDiscoverySenderEncryptedUnitTest.assertEquals((String)"wrong port", (int)1, (int)msg.getPort());
        UDPDiscoverySenderEncryptedUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.REMOVE, (Object)msg.getMessageType());
    }

    public void testRequestBroadcast() throws Exception {
        this.sender.requestBroadcast();
        UDPDiscoveryMessage msg = this.getMessage();
        UDPDiscoverySenderEncryptedUnitTest.assertNotNull((String)"message not received", (Object)msg);
        UDPDiscoverySenderEncryptedUnitTest.assertEquals((String)"wrong message type", (Object)UDPDiscoveryMessage.BroadcastType.REQUEST, (Object)msg.getMessageType());
    }

    private UDPDiscoveryMessage getMessage() {
        ExecutorService executor = Executors.newCachedThreadPool();
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                return UDPDiscoverySenderEncryptedUnitTest.this.receiver.waitForMessage();
            }
        };
        Future<Object> future = executor.submit(task);
        try {
            Object obj = future.get(3L, TimeUnit.SECONDS);
            UDPDiscoverySenderEncryptedUnitTest.assertTrue((String)"unexpected crap received", (boolean)(obj instanceof UDPDiscoveryMessage));
            return (UDPDiscoveryMessage)obj;
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            return null;
        }
    }
}

