/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public final class CompressionUtil {
    private static final Log log = LogManager.getLog(CompressionUtil.class);

    private CompressionUtil() {
    }

    public static byte[] decompressByteArray(byte[] input) {
        return CompressionUtil.decompressByteArray(input, 1024);
    }

    public static byte[] decompressByteArray(byte[] input, int bufferLength) {
        if (null == input) {
            throw new IllegalArgumentException("Input was null");
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[bufferLength];
        try {
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                baos.write(buf, 0, count);
            }
        }
        catch (DataFormatException ex) {
            log.error("Problem decompressing.", ex);
        }
        decompressor.end();
        try {
            baos.close();
        }
        catch (IOException ex) {
            log.error("Problem closing stream.", ex);
        }
        return baos.toByteArray();
    }

    public static byte[] compressByteArray(byte[] input) throws IOException {
        return CompressionUtil.compressByteArray(input, 1024);
    }

    public static byte[] compressByteArray(byte[] input, int bufferLength) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[bufferLength];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        compressor.end();
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] decompressGzipByteArray(byte[] compressedByteArray) throws IOException {
        return CompressionUtil.decompressGzipByteArray(compressedByteArray, 1024);
    }

    public static byte[] decompressGzipByteArray(byte[] compressedByteArray, int bufferlength) throws IOException {
        ByteArrayOutputStream uncompressedStream = new ByteArrayOutputStream();
        GZIPInputStream compressedStream = new GZIPInputStream(new ByteArrayInputStream(compressedByteArray));
        byte[] buffer = new byte[bufferlength];
        int index = -1;
        while ((index = compressedStream.read(buffer)) != -1) {
            uncompressedStream.write(buffer, 0, index);
        }
        return uncompressedStream.toByteArray();
    }
}

