/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCommand;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPSender;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class TestTCPLateralUnitTest
extends TestCase {
    private final MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();

    public void setUp() {
        JCS.setConfigFilename((String)"/TestTCPLateralCache.ccf");
    }

    private <K, V> CompositeCache<K, V> createCache(int port) {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(port);
        lattr.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        CompositeCache cache = this.cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)this.cacheMgr);
        return cache;
    }

    private <K, V> LateralTCPService<K, V> createService(int listenerPort, int serverPort, long listenerId) throws IOException {
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(listenerPort);
        lattr2.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lattr2.setTcpServer("localhost:" + serverPort);
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2, (IElementSerializer)new StandardSerializer());
        service.setListenerId(listenerId);
        return service;
    }

    public void testSimpleSend() throws Exception {
        JCS.getInstance((String)"test");
        TCPLateralCacheAttributes lac = new TCPLateralCacheAttributes();
        lac.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lac.setTcpServer("localhost:8111");
        lac.setTcpListenerPort(8111);
        CompositeCacheManager cacheMgr = CompositeCacheManager.getInstance();
        LateralTCPListener listener = LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lac, (ICompositeCacheManager)cacheMgr);
        LateralTCPSender lur = new LateralTCPSender((ITCPLateralCacheAttributes)lac, (IElementSerializer)new StandardSerializer());
        int numMes = 10;
        for (int i = 0; i < 10; ++i) {
            String message = "adsfasasfasfasdasf";
            CacheElement ce = new CacheElement("test", (Object)"test", (Object)"adsfasasfasfasdasf");
            LateralElementDescriptor led = new LateralElementDescriptor((ICacheElement)ce, LateralCommand.UPDATE, 1L);
            lur.send(led);
        }
        SleepUtil.sleepAtLeast(30L);
        TestTCPLateralUnitTest.assertEquals((String)"Should have received 10 by now.", (int)10, (int)listener.getPutCnt());
    }

    public void testReceive() throws Exception {
        this.createCache(1101);
        LateralTCPService service = this.createService(1102, 1101, 123456L);
        int cnt = 100;
        for (int i = 0; i < 100; ++i) {
            CacheElement element = new CacheElement("test", (Object)("key" + i), (Object)"value1");
            service.update((ICacheElement)element);
        }
        SleepUtil.sleepAtLeast(1000L);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct number", (long)100L, (long)this.cacheMgr.getCache().getUpdateCount());
    }

    public void testSameKeyDifferentObject() throws Exception {
        CompositeCache cache = this.createCache(1103);
        LateralTCPService service = this.createService(1104, 1103, 123456L);
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value1");
        service.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(300L);
        CacheElement element2 = new CacheElement("test", (Object)"key", (Object)"value2");
        service.update((ICacheElement)element2);
        SleepUtil.sleepAtLeast(1000L);
        ICacheElement cacheElement = cache.get((Object)"key");
        TestTCPLateralUnitTest.assertEquals((String)("Didn't get the correct object " + cacheElement), (String)((String)element2.getVal()), (String)((String)cacheElement.getVal()));
    }

    public void testSameKeyObjectDifferentValueObject() throws Exception {
        CompositeCache cache = this.createCache(1105);
        LateralTCPService service = this.createService(1106, 1105, 123456L);
        String key = "key";
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value1");
        service.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(300L);
        CacheElement element2 = new CacheElement("test", (Object)"key", (Object)"value2");
        service.update((ICacheElement)element2);
        SleepUtil.sleepAtLeast(1000L);
        ICacheElement cacheElement = cache.get((Object)"key");
        TestTCPLateralUnitTest.assertEquals((String)("Didn't get the correct object: " + cacheElement), (String)((String)element2.getVal()), (String)((String)cacheElement.getVal()));
    }

    public void testGet_SendAndReceived() throws Exception {
        CompositeCache cache = this.createCache(1107);
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value1");
        cache.update((ICacheElement)element);
        LateralTCPService service = this.createService(1108, 1107, 123456L);
        SleepUtil.sleepAtLeast(300L);
        ICacheElement result = service.get("test", (Object)"key");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct object", (String)((String)element.getVal()), (String)((String)result.getVal()));
    }

    public void testGetGroupKeys_SendAndReceived() throws Exception {
        CompositeCache cache = this.createCache(1150);
        GroupAttrName groupKey = new GroupAttrName(new GroupId("test", "group"), (Object)"key");
        CacheElement element = new CacheElement("test", (Object)groupKey, (Object)"value1");
        cache.update((ICacheElement)element);
        LateralTCPService service = this.createService(1151, 1150, 123459L);
        SleepUtil.sleepAtLeast(500L);
        Set result = service.getKeySet("test");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct object", (String)"key", (String)((String)((GroupAttrName)result.iterator().next()).attrName));
    }

    public void testGetMatching_WithData() throws Exception {
        CompositeCache cache = this.createCache(1108);
        String keyprefix1 = "MyPrefix1";
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("test", (Object)("MyPrefix1" + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element);
        }
        LateralTCPService service = this.createService(1108, 1108, 123456L);
        SleepUtil.sleepAtLeast(300L);
        Map result = service.getMatching("test", "MyPrefix1.+");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Wrong number returned 1:", (int)10, (int)result.size());
    }
}

