/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class IndexedDiskCacheDefragPerformanceTest
extends TestCase {
    private static final String LOG_DIVIDER = "---------------------------";
    private static final int TOTAL_ELEMENTS = 30000;
    private static final long SLEEP_TIME_DISK = 8000L;
    private static final int LOG_INCREMENT = 5000;
    private static final Runtime rt = Runtime.getRuntime();
    private static final DecimalFormat format = new DecimalFormat("#,###");

    public void testRealTimeOptimization() throws Exception {
        System.out.println(LOG_DIVIDER);
        System.out.println("JCS DEFRAG PERFORMANCE TESTS");
        System.out.println(LOG_DIVIDER);
        IndexedDiskCacheDefragPerformanceTest.logMemoryUsage();
        IndexedDiskCacheDefragPerformanceTest.runRealTimeOptimizationTest();
        IndexedDiskCacheDefragPerformanceTest.logMemoryUsage();
        System.out.println(LOG_DIVIDER);
    }

    private static void runRealTimeOptimizationTest() throws Exception {
        JCS.setConfigFilename((String)"/TestDiskCacheDefragPerformance.ccf");
        CacheAccess jcs = JCS.getInstance((String)"defrag");
        System.out.println("Cache Defrag Test");
        Random random = new Random(89L);
        for (int i = 0; i < 30000; ++i) {
            int bytes = random.nextInt(20);
            Tile tile = new Tile(i, new byte[(bytes + 4) * 1024]);
            jcs.put((Object)tile.id, (Object)tile);
            if (i != 0 && 0 == i % 100) {
                jcs.get((Object)random.nextInt(i));
            }
            if (0 != i % 5000) continue;
            System.out.print(i + ", ");
            Thread.sleep(8000L);
        }
        System.out.println(LOG_DIVIDER);
        System.out.println("Total elements = 30000");
        System.out.println("Stats prior to sleeping " + jcs.getStats());
        System.out.println("Sleeping for a a minute.");
        Thread.sleep(60000L);
        System.out.println(LOG_DIVIDER);
        System.out.println("Stats prior to dispose " + jcs.getStats());
        jcs.dispose();
        System.out.println(LOG_DIVIDER);
        System.out.println("Stats after dispose " + jcs.getStats());
        System.out.println("Done testing.");
    }

    private static void logMemoryUsage() {
        long byte2MB = 0x100000L;
        long total = rt.totalMemory() / 0x100000L;
        long free = rt.freeMemory() / 0x100000L;
        long used = total - free;
        System.out.println(LOG_DIVIDER);
        System.out.println("Memory: Used:" + format.format(used) + "MB Free:" + format.format(free) + "MB Total:" + format.format(total) + "MB");
    }

    public static void main(String[] args) {
        try {
            IndexedDiskCacheDefragPerformanceTest tester = new IndexedDiskCacheDefragPerformanceTest();
            tester.testRealTimeOptimization();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Tile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Integer id;
        public byte[] imageBytes;

        public Tile(Integer id, byte[] imageBytes) {
            this.id = id;
            this.imageBytes = imageBytes;
        }
    }
}

