/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheInvocationParameter;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs3.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs3.jcache.cdi.CacheInvocationParameterImpl;
import org.apache.commons.jcs3.jcache.cdi.CacheMethodDetailsImpl;

public class CacheInvocationContextImpl<A extends Annotation>
extends CacheMethodDetailsImpl<A>
implements CacheInvocationContext<A> {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private CacheInvocationParameter[] parameters;

    public CacheInvocationContextImpl(InvocationContext delegate, A cacheAnnotation, String cacheName, CDIJCacheHelper.MethodMeta meta) {
        super(delegate, cacheAnnotation, cacheName, meta);
    }

    public Object getTarget() {
        return this.delegate.getTarget();
    }

    public CacheInvocationParameter[] getAllParameters() {
        if (this.parameters == null) {
            this.parameters = this.doGetAllParameters(null);
        }
        return this.parameters;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException(cls.getName());
    }

    protected CacheInvocationParameter[] doGetAllParameters(Integer[] indexes) {
        Object[] parameters = this.delegate.getParameters();
        Object[] args = parameters == null ? EMPTY_ARGS : parameters;
        Class<?>[] parameterTypes = this.meta.getParameterTypes();
        List<Set<Annotation>> parameterAnnotations = this.meta.getParameterAnnotations();
        CacheInvocationParameter[] parametersAsArray = new CacheInvocationParameter[indexes == null ? args.length : indexes.length];
        if (indexes == null) {
            for (int i = 0; i < args.length; ++i) {
                parametersAsArray[i] = this.newCacheInvocationParameterImpl(parameterTypes[i], args[i], parameterAnnotations.get(i), i);
            }
        } else {
            int outIdx = 0;
            for (Integer i : indexes) {
                parametersAsArray[outIdx] = this.newCacheInvocationParameterImpl(parameterTypes[i], args[i], parameterAnnotations.get(i), i);
                ++outIdx;
            }
        }
        return parametersAsArray;
    }

    private CacheInvocationParameterImpl newCacheInvocationParameterImpl(Class<?> type, Object arg, Set<Annotation> annotations, int i) {
        return new CacheInvocationParameterImpl(type, arg, annotations, i);
    }
}

