/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.TestRemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.commons.jcs3.engine.CacheStatus;

public class RemoteCacheNoWaitFacadeUnitTest
extends TestCase {
    public void testAddNoWait_InList() {
        ArrayList<RemoteCacheNoWait> noWaits = new ArrayList<RemoteCacheNoWait>();
        RemoteCacheAttributes cattr = new RemoteCacheAttributes();
        cattr.setCacheName("testCache1");
        RemoteCache client = new RemoteCache((IRemoteCacheAttributes)cattr, null, null, null);
        RemoteCacheNoWait noWait = new RemoteCacheNoWait((IRemoteCacheClient)client);
        noWaits.add(noWait);
        RemoteCacheNoWaitFacade facade = new RemoteCacheNoWaitFacade(noWaits, (IRemoteCacheAttributes)cattr, null, null, null);
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have one entry.", (int)1, (int)facade.noWaits.size());
        RemoteCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.noWaits.contains(noWait));
        RemoteCacheNoWaitFacadeUnitTest.assertSame((String)"Should have same facade.", (Object)facade, (Object)((RemoteCache)((RemoteCacheNoWait)facade.noWaits.get(0)).getRemoteCache()).getFacade());
    }

    public void testFailover() {
        RemoteCacheAttributes cattr = new RemoteCacheAttributes();
        cattr.setCacheName("testCache1");
        cattr.setFailoverServers("localhost:1101,localhost:1102");
        cattr.setReceive(false);
        TestRemoteCacheFactory factory = new TestRemoteCacheFactory();
        factory.initialize();
        AuxiliaryCache cache = factory.createCache((AuxiliaryCacheAttributes)cattr, null, null, null);
        RemoteCacheNoWaitFacade facade = (RemoteCacheNoWaitFacade)cache;
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have two failovers.", (int)2, (int)cattr.getFailovers().size());
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have two managers.", (int)2, (int)factory.managers.size());
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have primary server.", (int)0, (int)cattr.getFailoverIndex());
        RemoteCacheNoWait primary = facade.getPrimaryServer();
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should be ALIVE", (Object)CacheStatus.ALIVE, (Object)primary.getStatus());
        facade.getPrimaryServer().getCacheEventQueue().destroy();
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should be ERROR", (Object)CacheStatus.ERROR, (Object)primary.getStatus());
        facade.attemptRestorePrimary = false;
        facade.connectAndRestore();
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have two failovers.", (int)2, (int)cattr.getFailovers().size());
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have two managers.", (int)2, (int)factory.managers.size());
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have switched to secondary server.", (int)1, (int)cattr.getFailoverIndex());
        RemoteCacheNoWaitFacadeUnitTest.assertNotSame((String)"Should have diferent primary now", (Object)primary, (Object)facade.getPrimaryServer());
        RemoteCacheNoWaitFacadeUnitTest.assertEquals((String)"Should be ALIVE", (Object)CacheStatus.ALIVE, (Object)facade.getPrimaryServer().getStatus());
    }
}

