/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.threadpool;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.props.PropertyLoader;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public class ThreadPoolManagerUnitTest
extends TestCase {
    public void testDefaultConfig() {
        Properties props = PropertyLoader.loadProperties("thread_pool.properties");
        ThreadPoolManager.setProps((Properties)props);
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        ExecutorService pool = mgr.getExecutorService("test1");
        ThreadPoolManagerUnitTest.assertNotNull((Object)pool);
    }

    public void testSpecialConfig() {
        Properties props = PropertyLoader.loadProperties("thread_pool.properties");
        ThreadPoolManager.setProps((Properties)props);
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        ExecutorService pool = mgr.getExecutorService("aborttest");
        ThreadPoolManagerUnitTest.assertNotNull((Object)pool);
    }

    public void testGetPoolNames() {
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        String poolName1 = "testGetPoolNames1";
        mgr.getExecutorService(poolName1);
        String poolName2 = "testGetPoolNames2";
        mgr.getExecutorService(poolName2);
        Set names = mgr.getPoolNames();
        ThreadPoolManagerUnitTest.assertTrue((String)"Should have name in list.", (boolean)names.contains(poolName1));
        ThreadPoolManagerUnitTest.assertTrue((String)"Should have name in list.", (boolean)names.contains(poolName2));
    }
}

