/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.struct;

import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.struct.LRUMap;

public class LRUMapUnitTest
extends TestCase {
    public void testPutWithSizeLimit() {
        int i;
        int size = 10;
        LRUMap cache = new LRUMap(size);
        for (i = 0; i < size; ++i) {
            cache.put("key:" + i, "data:" + i);
        }
        for (i = 0; i < size; ++i) {
            String data = (String)cache.get("key:" + i);
            LRUMapUnitTest.assertEquals((String)"Data is wrong.", (String)("data:" + i), (String)data);
        }
    }

    public void testPutWithNoSizeLimit() {
        int i;
        int size = 10;
        LRUMap cache = new LRUMap();
        for (i = 0; i < size; ++i) {
            cache.put("key:" + i, "data:" + i);
        }
        for (i = 0; i < size; ++i) {
            String data = (String)cache.get("key:" + i);
            LRUMapUnitTest.assertEquals((String)"Data is wrong.", (String)("data:" + i), (String)data);
        }
    }

    public void testPutAndRemove() {
        int size = 10;
        LRUMap cache = new LRUMap(size);
        cache.put("key:1", "data:1");
        String data = (String)cache.remove("key:1");
        LRUMapUnitTest.assertEquals((String)"Data is wrong.", (String)"data:1", (String)data);
    }

    public void testRemoveEmpty() {
        int size = 10;
        LRUMap cache = new LRUMap(size);
        Object returned = cache.remove("key:1");
        LRUMapUnitTest.assertNull((String)"Shouldn't hvae anything.", returned);
    }

    public void testGetEntrySet() {
        int size = 10;
        LRUMap cache = new LRUMap(size);
        for (int i = 0; i < size; ++i) {
            cache.put("key:" + i, "data:" + i);
        }
        Set entries = cache.entrySet();
        LRUMapUnitTest.assertEquals((String)"Set contains the wrong number of items.", (int)size, (int)entries.size());
        for (Map.Entry data : entries) {
            LRUMapUnitTest.assertTrue((String)"Data is wrong.", (((String)data.getValue()).indexOf("data:") != -1 ? 1 : 0) != 0);
        }
    }
}

