/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory.lru;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache;

public class LHMLRUMemoryCacheConcurrentUnitTest
extends TestCase {
    private static int items = 200;

    public LHMLRUMemoryCacheConcurrentUnitTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{LHMLRUMemoryCacheConcurrentUnitTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new LHMLRUMemoryCacheConcurrentUnitTest("testLHMLRUMemoryCache"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion1");
            }
        });
        return suite;
    }

    public void setUp() {
    }

    public void runTestForRegion(String region) throws Exception {
        int i;
        int i2;
        CompositeCacheManager cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
        cacheMgr.configure("/TestLHMLRUCache.ccf");
        CompositeCache cache = cacheMgr.getCache(region);
        LRUMemoryCache lru = new LRUMemoryCache();
        lru.initialize(cache);
        for (i2 = 0; i2 < items; ++i2) {
            CacheElement ice = new CacheElement(cache.getCacheName(), (Object)(i2 + ":key"), (Object)(region + " data " + i2));
            ice.setElementAttributes(cache.getElementAttributes());
            lru.update((ICacheElement)ice);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            LHMLRUMemoryCacheConcurrentUnitTest.assertNull((String)("Should not have " + i2 + ":key"), (Object)lru.get((Object)(i2 + ":key")));
        }
        for (i2 = 100; i2 < items; ++i2) {
            String value = (String)lru.get((Object)(i2 + ":key")).getVal();
            LHMLRUMemoryCacheConcurrentUnitTest.assertEquals((String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 < items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = lru.getMultiple(keys);
        for (i = 0; i < 100; ++i) {
            LHMLRUMemoryCacheConcurrentUnitTest.assertNull((String)("Should not have " + i + ":key"), elements.get(i + ":key"));
        }
        for (i = 100; i < items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            LHMLRUMemoryCacheConcurrentUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            LHMLRUMemoryCacheConcurrentUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i < items; ++i) {
            lru.remove((Object)(i + ":key"));
        }
        for (i = 0; i < items; ++i) {
            LHMLRUMemoryCacheConcurrentUnitTest.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)lru.get((Object)(i + ":key")));
        }
    }
}

