/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.MockAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.MockAuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.MockAuxiliaryCacheFactory;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheConfigurator;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.MockCacheEventLogger;

public class CompositeCacheConfiguratorUnitTest
extends TestCase {
    public void testParseAuxiliary_CacheEventLogger_Normal() {
        String regionName = "MyRegion";
        String auxName = "MockAux";
        String auxPrefix = "jcs.auxiliary." + auxName;
        String auxiliaryClassName = MockAuxiliaryCacheFactory.class.getName();
        String eventLoggerClassName = MockCacheEventLogger.class.getName();
        String auxiliaryAttributeClassName = MockAuxiliaryCacheAttributes.class.getName();
        Properties props = new Properties();
        props.put(auxPrefix, auxiliaryClassName);
        props.put(auxPrefix + ".attributes", auxiliaryAttributeClassName);
        props.put(auxPrefix + ".cacheeventlogger", eventLoggerClassName);
        CompositeCacheManager manager = CompositeCacheManager.getUnconfiguredInstance();
        CompositeCacheConfigurator configurator = new CompositeCacheConfigurator();
        AuxiliaryCache aux = configurator.parseAuxiliary(props, manager, auxName, regionName);
        MockAuxiliaryCache result = (MockAuxiliaryCache)aux;
        CompositeCacheConfiguratorUnitTest.assertNotNull((String)"Should have an auxcache.", (Object)((Object)result));
        CompositeCacheConfiguratorUnitTest.assertNotNull((String)"Should have an event logger.", (Object)result.getCacheEventLogger());
    }

    public void testParseSpoolChunkSize_Normal() {
        String regionName = "MyRegion";
        int chunkSize = 5;
        Properties props = new Properties();
        props.put("jcs.default", "");
        props.put("jcs.default.cacheattributes.SpoolChunkSize", String.valueOf(chunkSize));
        CompositeCacheManager manager = CompositeCacheManager.getUnconfiguredInstance();
        manager.configure(props);
        CompositeCache cache = manager.getCache(regionName);
        CompositeCacheConfiguratorUnitTest.assertEquals((String)"Wrong chunkSize", (int)cache.getCacheAttributes().getSpoolChunkSize(), (int)chunkSize);
    }
}

