/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.server;

import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs3.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class RemoteHttpCacheServiceUnitTest
extends TestCase {
    public void testUpdate_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        CacheElement element = new CacheElement(cacheName, (Object)key, null);
        server.update((ICacheElement)element, requesterId);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGet_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        server.get("region", (Object)"key");
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMatching_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        server.getMatching("region", "pattern", 0L);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMultiple_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        server.getMultiple("region", new HashSet());
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemove_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        server.remove("region", (Object)"key");
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemoveAll_simple() throws Exception {
        MockCompositeCacheManager manager = new MockCompositeCacheManager();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        RemoteHttpCacheService server = new RemoteHttpCacheService((ICompositeCacheManager)manager, rcsa, (ICacheEventLogger)cacheEventLogger);
        server.removeAll("region");
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteHttpCacheServiceUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }
}

