/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheService;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.utils.serialization.SerializationConversionUtil;

public class RemoteCacheUnitTest
extends TestCase {
    private IRemoteCacheAttributes cattr;
    private MockRemoteCacheService<String, String> service;
    private MockRemoteCacheListener<String, String> listener;
    private RemoteCacheMonitor monitor;

    protected void setUp() throws Exception {
        super.setUp();
        this.cattr = new RemoteCacheAttributes();
        this.service = new MockRemoteCacheService();
        this.listener = new MockRemoteCacheListener();
        this.monitor = new RemoteCacheMonitor();
    }

    public void testUpdate() throws Exception {
        long listenerId = 123L;
        this.listener.setListenerId(listenerId);
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement(cacheName, (Object)"key", (Object)"value");
        remoteCache.update((ICacheElement)element);
        RemoteCacheUnitTest.assertTrue((String)"The element should be in the serialized wrapper.", (boolean)(this.service.lastUpdate instanceof ICacheElementSerialized));
        ICacheElement result = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)((ICacheElementSerialized)this.service.lastUpdate), (IElementSerializer)remoteCache.getElementSerializer());
        RemoteCacheUnitTest.assertEquals((String)"Wrong element updated.", (String)((String)element.getVal()), (String)((String)result.getVal()));
        RemoteCacheUnitTest.assertEquals((String)"Wrong listener id.", (Object)listenerId, (Object)this.service.updateRequestIdList.get(0));
    }

    public void testUpdateZombieThenFix() throws Exception {
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        RemoteCache remoteCache = new RemoteCache(this.cattr, (ICacheServiceNonLocal)zombie, this.listener, this.monitor);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement(cacheName, (Object)"key", (Object)"value");
        remoteCache.update((ICacheElement)element);
        remoteCache.fixCache(this.service);
        RemoteCacheUnitTest.assertTrue((String)"The element should be in the serialized warapper.", (boolean)(this.service.lastUpdate instanceof ICacheElementSerialized));
        ICacheElement result = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)((ICacheElementSerialized)this.service.lastUpdate), (IElementSerializer)remoteCache.getElementSerializer());
        RemoteCacheUnitTest.assertEquals((String)"Wrong element updated.", (String)((String)element.getVal()), (String)((String)result.getVal()));
    }

    public void testUpdate_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        CacheElement item = new CacheElement("region", (Object)"key", (Object)"value");
        remoteCache.update((ICacheElement)item);
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGet_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.get((Object)"key");
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMultiple_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.getMultiple(new HashSet());
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemove_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.remove((Object)"key");
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemoveAll_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.remove((Object)"key");
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMatching_simple() throws Exception {
        String pattern = "adsfasdfasd.?";
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        Map result = remoteCache.getMatching(pattern);
        RemoteCacheUnitTest.assertNotNull((String)"Should have a map", (Object)result);
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testDispose_simple() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, this.listener, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.dispose();
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testDispose_nullListener() throws Exception {
        RemoteCache remoteCache = new RemoteCache(this.cattr, this.service, null, this.monitor);
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        remoteCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        remoteCache.dispose();
        RemoteCacheUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }
}

