/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.HsqlSetupTableUtil;
import org.apache.commons.jcs3.utils.timing.SleepUtil;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JDBCDiskCacheShrinkUnitTest {
    @BeforeClass
    public static void setupDatabase() throws Exception {
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        Properties p = new Properties();
        String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = p.getProperty("url", "jdbc:hsqldb:");
        String database = p.getProperty("database", rafroot + "/JDBCDiskCacheShrinkUnitTest");
        String user = p.getProperty("user", "sa");
        String password = p.getProperty("password", "");
        new jdbcDriver();
        Class.forName(driver).newInstance();
        Connection cConn = DriverManager.getConnection(url + database, user, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE_SHRINK");
    }

    @Before
    public void setUp() {
        JCS.setConfigFilename((String)"/TestJDBCDiskCacheShrink.ccf");
    }

    @Test
    public void testExpireInBackground() throws Exception {
        int i;
        String regionExpire = "expire1Second";
        int items = 200;
        CacheAccess jcsExpire = JCS.getInstance((String)regionExpire);
        for (i = 0; i <= items; ++i) {
            jcsExpire.put((Object)(i + ":key"), (Object)(regionExpire + " data " + i));
        }
        SleepUtil.sleepAtLeast(3000L);
        for (i = 0; i <= items; ++i) {
            Assert.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcsExpire.get((Object)(i + ":key")));
        }
    }

    @Test
    public void testDidNotExpire() throws CacheException, InterruptedException {
        int i;
        String region = "expire100Second";
        int items = 200;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
        }
        SleepUtil.sleepAtLeast(1000L);
        for (i = 0; i <= items; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            Assert.assertEquals((String)("key = [" + i + ":key] value = [" + value + "]"), (Object)(region + " data " + i), (Object)value);
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            Assert.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }

    @Test
    public void testDidNotExpireEternal() throws CacheException, InterruptedException {
        int i;
        String region = "eternal";
        int items = 200;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
        }
        SleepUtil.sleepAtLeast(1000L);
        for (i = 0; i <= items; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            Assert.assertEquals((String)("key = [" + i + ":key] value = [" + value + "]"), (Object)(region + " data " + i), (Object)value);
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            Assert.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

