/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskElementDescriptor;

public class LRUMapSizeVsCount
extends TestCase {
    double ratioPut = 0.0;
    double ratioGet = 0.0;
    float targetPut = 1.2f;
    float targetGet = 1.2f;
    int loops = 20;
    int tries = 100000;

    public LRUMapSizeVsCount(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(LRUMapSizeVsCount.class);
    }

    public void testSimpleLoad() throws Exception {
        this.doWork();
        LRUMapSizeVsCount.assertTrue((this.ratioPut < (double)this.targetPut ? 1 : 0) != 0);
        LRUMapSizeVsCount.assertTrue((this.ratioGet < (double)this.targetGet ? 1 : 0) != 0);
    }

    public void doWork() {
        long start = 0L;
        long end = 0L;
        long time = 0L;
        float tPer = 0.0f;
        long putTotalCount = 0L;
        long getTotalCount = 0L;
        long putTotalSize = 0L;
        long getTotalSize = 0L;
        long minTimeSizePut = Long.MAX_VALUE;
        long minTimeSizeGet = Long.MAX_VALUE;
        long minTimeCountPut = Long.MAX_VALUE;
        long minTimeCountGet = Long.MAX_VALUE;
        String cacheName = "LRUMap";
        String cache2Name = "";
        try {
            IndexedDiskCache idc;
            IndexedDiskCacheAttributes cattr = new IndexedDiskCacheAttributes();
            cattr.setName("junit");
            cattr.setCacheName("junit");
            cattr.setDiskPath(".");
            IndexedDiskCache indexedDiskCache = idc = new IndexedDiskCache(cattr);
            indexedDiskCache.getClass();
            IndexedDiskCache.LRUMapCountLimited cacheCount = new IndexedDiskCache.LRUMapCountLimited(indexedDiskCache, this.tries);
            IndexedDiskCache indexedDiskCache2 = idc;
            indexedDiskCache2.getClass();
            IndexedDiskCache.LRUMapSizeLimited cacheSize = new IndexedDiskCache.LRUMapSizeLimited(indexedDiskCache2, this.tries / 1024 / 2);
            for (int j = 0; j < this.loops; ++j) {
                int i;
                cacheName = "LRU Count           ";
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cacheCount.put("key:" + i, new IndexedDiskElementDescriptor((long)i, i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalCount += time;
                minTimeCountPut = Math.min(time, minTimeCountPut);
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cacheName + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cacheCount.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalCount += time;
                minTimeCountGet = Math.min(minTimeCountGet, time);
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cacheName + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                cache2Name = "LRU Size            ";
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cacheSize.put("key:" + i, new IndexedDiskElementDescriptor((long)i, i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalSize += time;
                minTimeSizePut = Math.min(minTimeSizePut, time);
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cache2Name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cacheSize.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalSize += time;
                minTimeSizeGet = Math.min(minTimeSizeGet, time);
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cache2Name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                System.out.println("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e);
        }
        long putAvCount = putTotalCount / (long)this.loops;
        long getAvCount = getTotalCount / (long)this.loops;
        long putAvSize = putTotalSize / (long)this.loops;
        long getAvSize = getTotalSize / (long)this.loops;
        System.out.println("Finished " + this.loops + " loops of " + this.tries + " gets and puts");
        System.out.println("\n");
        System.out.println("Put average for " + cacheName + " = " + putAvCount);
        System.out.println("Put average for " + cache2Name + " = " + putAvSize);
        this.ratioPut = (double)putAvSize * 1.0 / (double)putAvCount;
        System.out.println(cache2Name.trim() + " puts took " + this.ratioPut + " times the " + cacheName.trim() + ", the goal is <" + this.targetPut + "x");
        System.out.println("\n");
        System.out.println("Put minimum for " + cacheName + " = " + minTimeCountPut);
        System.out.println("Put minimum for " + cache2Name + " = " + minTimeSizePut);
        this.ratioPut = (double)minTimeSizePut * 1.0 / (double)minTimeCountPut;
        System.out.println(cache2Name.trim() + " puts took " + this.ratioPut + " times the " + cacheName.trim() + ", the goal is <" + this.targetPut + "x");
        System.out.println("\n");
        System.out.println("Get average for " + cacheName + " = " + getAvCount);
        System.out.println("Get average for " + cache2Name + " = " + getAvSize);
        this.ratioGet = Float.intBitsToFloat((int)getAvCount) / Float.intBitsToFloat((int)getAvSize);
        this.ratioGet = (double)getAvSize * 1.0 / (double)getAvCount;
        System.out.println(cache2Name.trim() + " gets took " + this.ratioGet + " times the " + cacheName.trim() + ", the goal is <" + this.targetGet + "x");
        System.out.println("\n");
        System.out.println("Get minimum for " + cacheName + " = " + minTimeCountGet);
        System.out.println("Get minimum for " + cache2Name + " = " + minTimeSizeGet);
        this.ratioPut = (double)minTimeSizeGet * 1.0 / (double)minTimeCountGet;
        System.out.println(cache2Name.trim() + " puts took " + this.ratioPut + " times the " + cacheName.trim() + ", the goal is <" + this.targetGet + "x");
    }

    public static void main(String[] args) {
        LRUMapSizeVsCount test = new LRUMapSizeVsCount("command");
        test.doWork();
    }
}

