/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class HugeQuantityBlockDiskCacheLoadTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestBlockDiskCacheHuge.ccf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeNumberOfItems() throws Exception {
        int items = 300000;
        String region = "testCache1";
        System.out.println("--------------------------");
        long initialMemory = this.measureMemoryUse();
        System.out.println("Before getting JCS: " + initialMemory);
        CacheAccess jcs = JCS.getInstance((String)region);
        jcs.clear();
        try {
            int i;
            ElapsedTimer timer = new ElapsedTimer();
            System.out.println("Start: " + this.measureMemoryUse());
            for (i = 0; i <= items; ++i) {
                jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
            }
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            System.out.println("After put: " + this.measureMemoryUse());
            Thread.sleep(5000L);
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            System.out.println("After wait: " + this.measureMemoryUse());
            for (i = 0; i < 10; ++i) {
                SleepUtil.sleepAtLeast(3000L);
                System.out.println("--------------------------");
                System.out.println("After sleep. " + timer.getElapsedTimeString() + " memory used = " + this.measureMemoryUse());
                System.out.println(jcs.getStats());
            }
            System.out.println("--------------------------");
            System.out.println("Retrieving all.");
            for (i = 0; i <= items; ++i) {
                String value = (String)jcs.get((Object)(i + ":key"));
                if (i % 1000 == 0) {
                    System.out.println(i + " ");
                }
                HugeQuantityBlockDiskCacheLoadTest.assertEquals((String)"Wrong value returned.", (String)(region + " data " + i), (String)value);
            }
            long aftetGet = this.measureMemoryUse();
            System.out.println("After get: " + aftetGet + " diff = " + (aftetGet - initialMemory));
        }
        finally {
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            long endMemory = this.measureMemoryUse();
            System.out.println("End: " + endMemory + " diff = " + (endMemory - initialMemory));
        }
    }

    protected long measureMemoryUse() throws InterruptedException {
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

