/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public abstract class BlockDiskCacheUnitTestAbstract
extends TestCase {
    public abstract BlockDiskCacheAttributes getCacheAttributes();

    public void testPutGetMatching_SmallWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_SmallWait";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        for (int i = 0; i <= items; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)(i + ":key"), (Object)(cacheName + " data " + i)));
        }
        Thread.sleep(500L);
        Map matchingResults = diskCache.getMatching("1.8.+");
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testPutGetMatching_NoWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_NoWait";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        for (int i = 0; i <= items; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)(i + ":key"), (Object)(cacheName + " data " + i)));
        }
        Map matchingResults = diskCache.getMatching("1.8.+");
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testChunk_BigString() throws Exception {
        String string = "This is my big string ABCDEFGH";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append("|" + i + ":" + sb.toString());
        }
        string = sb.toString();
        StandardSerializer elementSerializer = new StandardSerializer();
        byte[] data = elementSerializer.serialize((Object)string);
        File file = new File("target/test-sandbox/BlockDiskCacheUnitTest/testChunk_BigString.data");
        BlockDisk blockDisk = new BlockDisk(file, 200, (IElementSerializer)elementSerializer);
        int numBlocksNeeded = blockDisk.calculateTheNumberOfBlocksNeeded(data);
        byte[][] chunks = blockDisk.getBlockChunks(data, numBlocksNeeded);
        byte[] resultData = new byte[]{};
        for (int i = 0; i < chunks.length; i = (int)((short)(i + 1))) {
            byte[] chunk = chunks[i];
            byte[] newTotal = new byte[data.length + chunk.length];
            System.arraycopy(data, 0, newTotal, 0, data.length);
            System.arraycopy(chunk, 0, newTotal, data.length, chunk.length);
            resultData = newTotal;
        }
        Serializable result = (Serializable)elementSerializer.deSerialize(resultData, null);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (Object)string, (Object)result);
        blockDisk.close();
    }

    public void testPutGet_BigString() throws Exception {
        String string = "This is my big string ABCDEFGH";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(" " + i + sb.toString());
        }
        string = sb.toString();
        String cacheName = "testPutGet_BigString";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(200);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)string));
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        String after = (String)afterElement.getVal();
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after);
    }

    public void testUTF8String() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String cacheName = "testUTF8String";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(200);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)string));
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        String after = (String)afterElement.getVal();
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after);
    }

    public void testUTF8ByteArray() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        String cacheName = "testUTF8ByteArray";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(200);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)bytes));
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        byte[] after = (byte[])afterElement.getVal();
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong bytes after retrieval", (int)bytes.length, (int)after.length);
    }

    public void testUTF8StringAndBytes() throws Exception {
        X before = new X();
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        before.string = string = sb.toString();
        before.bytes = string.getBytes(StandardCharsets.UTF_8);
        String cacheName = "testUTF8StringAndBytes";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(500);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)before));
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        X after = (X)afterElement.getVal();
        BlockDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after.string);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong bytes after retrieval", (String)string, (String)new String(after.bytes, StandardCharsets.UTF_8));
    }

    public void testLoadFromDisk() throws Exception {
        for (int i = 0; i < 20; ++i) {
            this.oneLoadFromDisk();
        }
    }

    public void testAppendToDisk() throws Exception {
        String cacheName = "testAppendToDisk";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(500);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        diskCache.removeAll();
        X value1 = new X();
        value1.string = "1234567890";
        X value2 = new X();
        value2.string = "0987654321";
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"1", (Object)value1));
        diskCache.dispose();
        diskCache = new BlockDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"2", (Object)value2));
        diskCache.dispose();
        diskCache = new BlockDiskCache(cattr);
        BlockDiskCacheUnitTestAbstract.assertTrue((boolean)diskCache.verifyDisk());
        BlockDiskCacheUnitTestAbstract.assertEquals((int)2, (int)diskCache.getKeySet().size());
        BlockDiskCacheUnitTestAbstract.assertEquals((String)value1.string, (String)((X)diskCache.get((Object)"1").getVal()).string);
        BlockDiskCacheUnitTestAbstract.assertEquals((String)value2.string, (String)((X)diskCache.get((Object)"2").getVal()).string);
    }

    public void oneLoadFromDisk() throws Exception {
        int i;
        X before = new X();
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(sb.toString());
        }
        before.string = string = sb.toString();
        before.bytes = string.getBytes(StandardCharsets.UTF_8);
        String cacheName = "testLoadFromDisk";
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setBlockSizeBytes(500);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache diskCache = new BlockDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)("x" + i), (Object)before));
        }
        diskCache.dispose();
        diskCache = new BlockDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            ICacheElement afterElement = diskCache.get((Object)("x" + i));
            BlockDiskCacheUnitTestAbstract.assertNotNull((String)("Missing element from cache. Cache size: " + diskCache.getSize() + " element: x" + i), (Object)afterElement);
            X after = (X)afterElement.getVal();
            BlockDiskCacheUnitTestAbstract.assertNotNull((Object)after);
            BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after.string);
            BlockDiskCacheUnitTestAbstract.assertEquals((String)"wrong bytes after retrieval", (String)string, (String)new String(after.bytes, StandardCharsets.UTF_8));
        }
        diskCache.dispose();
    }

    public void testRemoveItems() throws IOException {
        int i;
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveItems");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache disk = new BlockDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement("testRemoveItems", (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 0; i < cnt; ++i) {
            disk.remove((Object)("key:" + i));
            ICacheElement element = disk.processGet((Object)("key:" + i));
            BlockDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    public void testRemove_PartialKey() throws IOException {
        ICacheElement element;
        int i;
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_PartialKey");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache disk = new BlockDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element2 = new CacheElement("testRemove_PartialKey", (Object)(i + ":key"), (Object)("data:" + i));
            element2.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element2);
        }
        for (i = 0; i < cnt; ++i) {
            element = disk.processGet((Object)(i + ":key"));
            BlockDiskCacheUnitTestAbstract.assertNotNull((String)"Shoulds have received an element.", (Object)element);
        }
        for (i = 0; i < cnt; ++i) {
            disk.remove((Object)(i + ":"));
            element = disk.processGet((Object)(i + ":key"));
            BlockDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    public void testRemove_Group() throws IOException {
        ICacheElement element;
        GroupAttrName<String> groupAttrName;
        int i;
        BlockDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_Group");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        BlockDiskCache disk = new BlockDiskCache(cattr);
        disk.processRemoveAll();
        String cacheName = "testRemove_Group_Region";
        String groupName = "testRemove_Group";
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = new CacheElement(cacheName, groupAttrName, (Object)("data:" + i));
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate(element);
        }
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = disk.processGet(groupAttrName);
            BlockDiskCacheUnitTestAbstract.assertNotNull((String)"Should have received an element.", (Object)element);
        }
        disk.remove(this.getGroupAttrName(cacheName, groupName, null));
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = disk.processGet(groupAttrName);
            BlockDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    private GroupAttrName<String> getGroupAttrName(String cacheName, String group, String name) {
        GroupId gid = new GroupId(cacheName, group);
        return new GroupAttrName(gid, (Object)name);
    }

    static class X
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String string;
        byte[] bytes;

        X() {
        }
    }
}

