/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskKeyStore;

public class BlockDiskCacheKeyStoreUnitTest
extends TestCase {
    private final String rootDirName = "target/test-sandbox/block";

    public void testPutKeys() throws Exception {
        BlockDiskCacheAttributes attributes = new BlockDiskCacheAttributes();
        attributes.setCacheName("testPutKeys");
        attributes.setDiskPath("target/test-sandbox/block");
        attributes.setMaxKeySize(1000);
        attributes.setBlockSizeBytes(2000);
        this.innerTestPutKeys(attributes);
    }

    public void testPutKeysSize() throws Exception {
        BlockDiskCacheAttributes attributes = new BlockDiskCacheAttributes();
        attributes.setCacheName("testPutKeys");
        attributes.setDiskPath("target/test-sandbox/block");
        attributes.setMaxKeySize(100000);
        attributes.setBlockSizeBytes(1024);
        attributes.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        this.innerTestPutKeys(attributes);
    }

    private void innerTestPutKeys(BlockDiskCacheAttributes attributes) {
        int i;
        BlockDiskCache blockDiskCache = new BlockDiskCache(attributes);
        BlockDiskKeyStore keyStore = new BlockDiskKeyStore(attributes, blockDiskCache);
        int numElements = 100;
        for (i = 0; i < numElements; ++i) {
            keyStore.put((Object)String.valueOf(i), new int[i]);
        }
        BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong number of keys", (int)numElements, (int)keyStore.size());
        for (i = 0; i < numElements; ++i) {
            int[] result = keyStore.get((Object)String.valueOf(i));
            BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong array returned.", (int)i, (int)result.length);
        }
    }

    public void testSaveLoadKeys() throws Exception {
        BlockDiskCacheAttributes attributes = new BlockDiskCacheAttributes();
        attributes.setCacheName("testSaveLoadKeys");
        attributes.setDiskPath("target/test-sandbox/block");
        attributes.setMaxKeySize(10000);
        attributes.setBlockSizeBytes(2000);
        this.testSaveLoadKeysInner(attributes);
    }

    public void testSaveLoadKeysSize() throws Exception {
        BlockDiskCacheAttributes attributes = new BlockDiskCacheAttributes();
        attributes.setCacheName("testSaveLoadKeys");
        attributes.setDiskPath("target/test-sandbox/block");
        attributes.setMaxKeySize(10000);
        attributes.setBlockSizeBytes(2000);
        this.testSaveLoadKeysInner(attributes);
    }

    private void testSaveLoadKeysInner(BlockDiskCacheAttributes attributes) {
        int i;
        BlockDiskKeyStore keyStore = new BlockDiskKeyStore(attributes, null);
        int numElements = 1000;
        int blockIndex = 0;
        for (i = 0; i < numElements; ++i) {
            int blocks = i;
            int[] block1 = new int[blocks];
            int[] block2 = new int[blocks];
            for (int j = 0; j < blocks; ++j) {
                block1[j] = blockIndex++;
                block2[j] = blockIndex++;
            }
            keyStore.put((Object)String.valueOf(i), block1);
            keyStore.put((Object)String.valueOf(i), block2);
        }
        BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong number of keys", (int)numElements, (int)keyStore.size());
        keyStore.saveKeys();
        keyStore.clearMemoryMap();
        BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong number of keys after clearing memory", (int)0, (int)keyStore.size());
        keyStore.loadKeys();
        BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong number of keys after loading", (int)numElements, (int)keyStore.size());
        for (i = 0; i < numElements; ++i) {
            int[] result = keyStore.get((Object)String.valueOf(i));
            BlockDiskCacheKeyStoreUnitTest.assertEquals((String)"Wrong array returned.", (int)i, (int)result.length);
        }
    }

    public void testObjectLargerThanMaxSize() {
        BlockDiskCacheAttributes attributes = new BlockDiskCacheAttributes();
        attributes.setCacheName("testObjectLargerThanMaxSize");
        attributes.setDiskPath("target/test-sandbox/block");
        attributes.setMaxKeySize(1000);
        attributes.setBlockSizeBytes(2000);
        attributes.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        BlockDiskKeyStore keyStore = new BlockDiskKeyStore(attributes, new BlockDiskCache(attributes));
        keyStore.put((Object)"1", new int[1000]);
        keyStore.put((Object)"2", new int[1000]);
        BlockDiskCacheKeyStoreUnitTest.assertNull((Object)keyStore.get((Object)"1"));
        BlockDiskCacheKeyStoreUnitTest.assertNotNull((Object)keyStore.get((Object)"2"));
    }
}

