/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.TestLogConfigurationUtil;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;

public class AbstractDiskCacheUnitTest
extends TestCase {
    public void testUpdateGet_allowed() throws IOException {
        String cacheName = "testUpdateGet_allowed";
        IndexedDiskCacheAttributes diskCacheAttributes = new IndexedDiskCacheAttributes();
        diskCacheAttributes.setCacheName(cacheName);
        AbstractDiskCacheTestInstance diskCache = new AbstractDiskCacheTestInstance((IDiskCacheAttributes)diskCacheAttributes);
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        diskCache.update((ICacheElement)cacheElement);
        ICacheElement result = diskCache.get(key);
        AbstractDiskCacheUnitTest.assertNotNull((String)"Item should be in the map.", (Object)result);
    }

    public void testDispose() throws IOException {
        String cacheName = "testDispose";
        IndexedDiskCacheAttributes diskCacheAttributes = new IndexedDiskCacheAttributes();
        diskCacheAttributes.setCacheName(cacheName);
        AbstractDiskCacheTestInstance diskCache = new AbstractDiskCacheTestInstance((IDiskCacheAttributes)diskCacheAttributes);
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        diskCache.update((ICacheElement)cacheElement);
        diskCache.dispose();
        AbstractDiskCacheUnitTest.assertFalse((String)"disk cache should not be alive.", (boolean)diskCache.isAlive());
        AbstractDiskCacheUnitTest.assertEquals((String)"Status should be disposed", (Object)CacheStatus.DISPOSED, (Object)diskCache.getStatus());
    }

    public void testRemoveAll_notAllowed() throws IOException {
        StringWriter stringWriter = new StringWriter();
        TestLogConfigurationUtil.configureLogger(stringWriter, AbstractDiskCache.class.getName());
        IndexedDiskCacheAttributes diskCacheAttributes = new IndexedDiskCacheAttributes();
        diskCacheAttributes.setAllowRemoveAll(false);
        AbstractDiskCacheTestInstance diskCache = new AbstractDiskCacheTestInstance((IDiskCacheAttributes)diskCacheAttributes);
        String cacheName = "testRemoveAll_notAllowed";
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        diskCache.update((ICacheElement)cacheElement);
        diskCache.removeAll();
        String result = stringWriter.toString();
        AbstractDiskCacheUnitTest.assertTrue((String)"Should say not allowed.", (result.indexOf("set to false") != -1 ? 1 : 0) != 0);
        AbstractDiskCacheUnitTest.assertNotNull((String)"Item should be in the map.", (Object)diskCache.get(key));
    }

    public void testRemoveAll_allowed() throws IOException {
        IndexedDiskCacheAttributes diskCacheAttributes = new IndexedDiskCacheAttributes();
        diskCacheAttributes.setAllowRemoveAll(true);
        AbstractDiskCacheTestInstance diskCache = new AbstractDiskCacheTestInstance((IDiskCacheAttributes)diskCacheAttributes);
        String cacheName = "testRemoveAll_allowed";
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        diskCache.update((ICacheElement)cacheElement);
        diskCache.removeAll();
        AbstractDiskCacheUnitTest.assertNull((String)"Item should not be in the map.", (Object)diskCache.get(key));
    }

    protected static class AbstractDiskCacheTestInstance<K, V>
    extends AbstractDiskCache<K, V> {
        protected Map<K, ICacheElement<K, V>> map = new HashMap<K, ICacheElement<K, V>>();
        protected IDiskCacheAttributes diskCacheAttributes;

        public AbstractDiskCacheTestInstance(IDiskCacheAttributes attr) {
            super(attr);
            this.diskCacheAttributes = attr;
            this.setAlive(true);
        }

        protected String getDiskLocation() {
            return "memory";
        }

        public Set<K> getKeySet() throws IOException {
            return new HashSet<K>(this.map.keySet());
        }

        public int getSize() {
            return this.map.size();
        }

        protected void processDispose() throws IOException {
        }

        protected ICacheElement<K, V> processGet(K key) throws IOException {
            return this.map.get(key);
        }

        protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) throws IOException {
            return Collections.emptyMap();
        }

        protected boolean processRemove(K key) throws IOException {
            return this.map.remove(key) != null;
        }

        protected void processRemoveAll() throws IOException {
            this.map.clear();
        }

        protected void processUpdate(ICacheElement<K, V> cacheElement) throws IOException {
            this.map.put(cacheElement.getKey(), cacheElement);
        }

        public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
            return this.diskCacheAttributes;
        }
    }
}

