/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.MockElementSerializer;
import org.apache.commons.jcs3.engine.logging.MockCacheEventLogger;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class AuxiliaryCacheConfiguratorUnitTest
extends TestCase {
    public void testParseCacheEventLogger_Null() {
        Properties props = new Properties();
        MockCacheEventLogger result = (MockCacheEventLogger)AuxiliaryCacheConfigurator.parseCacheEventLogger((Properties)props, (String)"junk");
        AuxiliaryCacheConfiguratorUnitTest.assertNull((String)"Should not have a logger.", (Object)result);
    }

    public void testParseCacheEventLogger_NullName() {
        Properties props = new Properties();
        MockCacheEventLogger result = (MockCacheEventLogger)AuxiliaryCacheConfigurator.parseCacheEventLogger((Properties)props, null);
        AuxiliaryCacheConfiguratorUnitTest.assertNull((String)"Should not have a logger.", (Object)result);
    }

    public void testParseCacheEventLogger_Normal() {
        String auxPrefix = "jcs.auxiliary.MYAux";
        String testPropertyValue = "This is the value";
        String className = MockCacheEventLogger.class.getName();
        Properties props = new Properties();
        props.put(auxPrefix + ".cacheeventlogger", className);
        props.put(auxPrefix + ".cacheeventlogger" + ".attributes" + ".testProperty", testPropertyValue);
        MockCacheEventLogger result = (MockCacheEventLogger)AuxiliaryCacheConfigurator.parseCacheEventLogger((Properties)props, (String)auxPrefix);
        AuxiliaryCacheConfiguratorUnitTest.assertNotNull((String)"Should have a logger.", (Object)result);
        AuxiliaryCacheConfiguratorUnitTest.assertEquals((String)"Property should be set.", (String)testPropertyValue, (String)result.getTestProperty());
    }

    public void testParseElementSerializer_Normal() {
        String auxPrefix = "jcs.auxiliary.MYAux";
        String testPropertyValue = "This is the value";
        String className = MockElementSerializer.class.getName();
        Properties props = new Properties();
        props.put(auxPrefix + ".serializer", className);
        props.put(auxPrefix + ".serializer" + ".attributes" + ".testProperty", testPropertyValue);
        MockElementSerializer result = (MockElementSerializer)AuxiliaryCacheConfigurator.parseElementSerializer((Properties)props, (String)auxPrefix);
        AuxiliaryCacheConfiguratorUnitTest.assertNotNull((String)"Should have a Serializer.", (Object)result);
        AuxiliaryCacheConfiguratorUnitTest.assertEquals((String)"Property should be set.", (String)testPropertyValue, (String)result.getTestProperty());
    }

    public void testParseElementSerializer_Null() {
        Properties props = new Properties();
        IElementSerializer result = AuxiliaryCacheConfigurator.parseElementSerializer((Properties)props, (String)"junk");
        AuxiliaryCacheConfiguratorUnitTest.assertTrue((String)"Should have the default Serializer.", (boolean)(result instanceof StandardSerializer));
    }
}

