/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class JCSRemovalSimpleConcurrentTest
extends TestCase {
    public JCSRemovalSimpleConcurrentTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        JCS.setConfigFilename((String)"/TestRemoval.ccf");
        JCS.getInstance((String)"testCache1");
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{JCSRemovalSimpleConcurrentTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testTwoDeepRemoval() throws Exception {
        int i;
        int count = 500;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (i = 0; i <= count; ++i) {
            jcs.put((Object)("key:" + i + ":anotherpart"), (Object)("data" + i));
        }
        for (i = count; i >= 0; --i) {
            String res = (String)jcs.get((Object)("key:" + i + ":anotherpart"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[key:" + i + ":anotherpart] should not be null, " + jcs.getStats()), (Object)res);
        }
        for (i = 0; i <= count; ++i) {
            jcs.remove((Object)("key:" + i + ":"));
            JCSRemovalSimpleConcurrentTest.assertNull((String)jcs.getStats(), (Object)jcs.get((Object)("key:" + i + ":anotherpart")));
        }
    }

    public void testSingleDepthRemoval() throws Exception {
        int i;
        int count = 500;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (i = 0; i <= count; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = count; i >= 0; --i) {
            String res = (String)jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        for (i = 0; i <= count; ++i) {
            jcs.remove((Object)(i + ":"));
            JCSRemovalSimpleConcurrentTest.assertNull((Object)jcs.get((Object)(i + ":key")));
        }
    }

    public void testClear() throws Exception {
        String res;
        int i;
        int count = 500;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (i = 0; i <= count; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = count; i >= 0; --i) {
            res = (String)jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        jcs.clear();
        for (i = count; i >= 0; --i) {
            res = (String)jcs.get((Object)(i + ":key"));
            if (res == null) continue;
            JCSRemovalSimpleConcurrentTest.assertNull((String)("[" + i + ":key] should be null after remvoeall" + jcs.getStats()), (Object)res);
        }
    }

    public void testClearRepeatedlyWithoutError() throws Exception {
        String res;
        int i;
        int count = 500;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        jcs.clear();
        for (i = 0; i <= count; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = count; i >= 0; --i) {
            res = (String)jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        for (i = count; i >= 0; --i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
            jcs.clear();
            res = (String)jcs.get((Object)(i + ":key"));
            if (res == null) continue;
            JCSRemovalSimpleConcurrentTest.assertNull((String)("[" + i + ":key] should be null after remvoeall" + jcs.getStats()), (Object)res);
        }
    }
}

