/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.serialization.CompressingSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class CompressingSerializerUnitTest
extends TestCase {
    public void testDeserialize_NullInput() throws IOException, ClassNotFoundException {
        CompressingSerializer serializer = new CompressingSerializer();
        Object result = serializer.deSerialize(null, null);
        CompressingSerializerUnitTest.assertNull((String)"Should have nothing.", (Object)result);
    }

    public void testSimpleBackAndForth() throws Exception {
        CompressingSerializer serializer = new CompressingSerializer();
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231";
        String after = (String)serializer.deSerialize(serializer.serialize((Object)before), null);
        CompressingSerializerUnitTest.assertEquals((String)"Before and after should be the same.", (String)before, (String)after);
    }

    public void testSerialize_NullInput() throws Exception {
        CompressingSerializer serializer = new CompressingSerializer();
        Object before = null;
        byte[] serialized = serializer.serialize(before);
        String after = (String)serializer.deSerialize(serialized, null);
        CompressingSerializerUnitTest.assertNull((String)("Should have nothing. after =" + after), (Object)after);
    }

    public void testSerialize_CompareCompressedAndUncompressed() throws Exception {
        CompressingSerializer serializer = new CompressingSerializer();
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdssaf dsaf sadf dsaf dsaf dsaf dsafdsa fdsaf dsaf dsafdsa dsaf dsaf dsaf dsaf dsafdsa76f dsa798f dsa6fdsa 087f  gh 987dsahb dsahbuhbfnui nufdsa hbv87 f8vhdsgbnfv h8fdg8dfjvn8fdwgj fdsgjb9fdsjbvjvhjv hg98f-dsaghj j9fdsb gfsb 9fdshjbgb987fdsbfdwgh ujbhjbhb hbfdsgh fdshb Ofdsgyfesgyfdsafdsafsa333 31231";
        byte[] compressed = serializer.serialize((Object)before);
        byte[] nonCompressed = new StandardSerializer().serialize((Object)before);
        CompressingSerializerUnitTest.assertTrue((String)("Compressed should be smaller. compressed size = " + compressed.length + "nonCompressed size = " + nonCompressed.length), (compressed.length < nonCompressed.length ? 1 : 0) != 0);
    }
}

