/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.discovery.MockDiscoveryListener;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class UDPDiscoveryUnitTest
extends TestCase {
    public void testSimpleUDPDiscovery() throws Exception {
        int cnt;
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr("228.5.6.7");
        attributes.setUdpDiscoveryPort(6789);
        attributes.setServicePort(1000);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes);
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        UDPDiscoveryReceiver receiver = new UDPDiscoveryReceiver(service, null, attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort());
        Thread t = new Thread((Runnable)receiver);
        t.start();
        UDPDiscoverySender sender = new UDPDiscoverySender(attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort(), 4);
        ArrayList<String> cacheNames = new ArrayList<String>();
        int numJunk = 10;
        for (int i = 0; i < numJunk; ++i) {
            cacheNames.add("junkCacheName" + i);
        }
        cacheNames.add("testCache1");
        int max = 10;
        for (cnt = 0; cnt < max; ++cnt) {
            sender.passiveBroadcast("localhost", 1111, cacheNames, 1L);
            SleepUtil.sleepAtLeast(20L);
        }
        SleepUtil.sleepAtLeast(200L);
        UDPDiscoveryUnitTest.assertTrue((String)("Receiver count [" + receiver.getCnt() + "] should be the at least the number sent [" + cnt + "]."), (cnt <= receiver.getCnt() ? 1 : 0) != 0);
        sender.close();
    }
}

