/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.MockDiscoveryListener;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;

public class UDPDiscoveryServiceUnitTest
extends TestCase {
    public void testAddOrUpdateService_NotInList() {
        String host = "228.5.6.7";
        int port = 6789;
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(host);
        attributes.setUdpDiscoveryPort(port);
        attributes.setServicePort(1000);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes);
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        service.addOrUpdateService(discoveredService);
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)discoveryListener.discoveredServices.contains(discoveredService));
    }

    public void testAddOrUpdateService_InList_NamesDoNotChange() {
        String host = "228.5.6.7";
        int port = 6789;
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(host);
        attributes.setUdpDiscoveryPort(port);
        attributes.setServicePort(1000);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes);
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        ArrayList<String> sametCacheNames = new ArrayList<String>();
        sametCacheNames.add("name1");
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(sametCacheNames);
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        DiscoveredService discoveredService2 = new DiscoveredService();
        discoveredService2.setServiceAddress(host);
        discoveredService2.setCacheNames(sametCacheNames);
        discoveredService2.setServicePort(1000);
        discoveredService2.setLastHearFromTime(500L);
        service.addOrUpdateService(discoveredService);
        service.addOrUpdateService(discoveredService2);
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Should only be one in the set.", (int)1, (int)service.getDiscoveredServices().size());
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)discoveryListener.discoveredServices.contains(discoveredService));
        for (DiscoveredService service1 : service.getDiscoveredServices()) {
            if (!discoveredService.equals((Object)service1)) continue;
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The match should have the new last heard from time.", (long)service1.getLastHearFromTime(), (long)discoveredService2.getLastHearFromTime());
        }
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Mock should have been called twice.", (int)2, (int)discoveryListener.discoveredServices.size());
    }

    public void testAddOrUpdateService_InList_NamesChange() {
        String host = "228.5.6.7";
        int port = 6789;
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(host);
        attributes.setUdpDiscoveryPort(port);
        attributes.setServicePort(1000);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes);
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        ArrayList<String> differentCacheNames = new ArrayList<String>();
        differentCacheNames.add("name1");
        DiscoveredService discoveredService2 = new DiscoveredService();
        discoveredService2.setServiceAddress(host);
        discoveredService2.setCacheNames(differentCacheNames);
        discoveredService2.setServicePort(1000);
        discoveredService2.setLastHearFromTime(500L);
        service.addOrUpdateService(discoveredService);
        service.addOrUpdateService(discoveredService2);
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Should only be one in the set.", (int)1, (int)service.getDiscoveredServices().size());
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)discoveryListener.discoveredServices.contains(discoveredService));
        for (DiscoveredService service1 : service.getDiscoveredServices()) {
            if (!discoveredService.equals((Object)service1)) continue;
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The match should have the new last heard from time.", (long)service1.getLastHearFromTime(), (long)discoveredService2.getLastHearFromTime());
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The names should be updated.", (String)(service1.getCacheNames() + ""), (String)(differentCacheNames + ""));
        }
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Mock should have been called twice.", (int)2, (int)discoveryListener.discoveredServices.size());
        UDPDiscoveryServiceUnitTest.assertEquals((String)"The second mock listener add should be discoveredService2", (Object)discoveredService2, (Object)discoveryListener.discoveredServices.get(1));
    }

    public void testRemoveDiscoveredService() {
        String host = "228.5.6.7";
        int port = 6789;
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(host);
        attributes.setUdpDiscoveryPort(port);
        attributes.setServicePort(1000);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes);
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        service.addOrUpdateService(discoveredService);
        service.removeDiscoveredService(discoveredService);
        UDPDiscoveryServiceUnitTest.assertFalse((String)"Service should not be in the service list.", (boolean)service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertFalse((String)"Service should not be in the listener list.", (boolean)discoveryListener.discoveredServices.contains(discoveredService));
    }
}

