/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory.shrinking;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.ElementAttributesUtils;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.event.ElementEventHandlerMockImpl;
import org.apache.commons.jcs3.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs3.engine.memory.MockMemoryCache;
import org.apache.commons.jcs3.engine.memory.shrinking.ShrinkerThread;

public class ShrinkerThreadUnitTest
extends TestCase {
    public void testCheckForRemoval_Expired() throws IOException {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMaxMemoryIdleTimeSeconds(10L);
        cacheAttr.setMaxSpoolPerRun(10);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        String key = "key";
        String value = "value";
        CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
        ElementAttributes elementAttr = new ElementAttributes();
        elementAttr.setIsEternal(false);
        element.setElementAttributes((IElementAttributes)elementAttr);
        element.getElementAttributes().setMaxLife(1L);
        long now = System.currentTimeMillis();
        boolean result = cache.isExpired((ICacheElement)element, now += 2000L, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND);
        ShrinkerThreadUnitTest.assertTrue((String)"Item should have expired.", (boolean)result);
    }

    public void testCheckForRemoval_NotExpired() throws IOException {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMaxMemoryIdleTimeSeconds(10L);
        cacheAttr.setMaxSpoolPerRun(10);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        String key = "key";
        String value = "value";
        CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
        ElementAttributes elementAttr = new ElementAttributes();
        elementAttr.setIsEternal(false);
        element.setElementAttributes((IElementAttributes)elementAttr);
        element.getElementAttributes().setMaxLife(1L);
        long now = System.currentTimeMillis();
        boolean result = cache.isExpired((ICacheElement)element, now -= 2000L, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND);
        ShrinkerThreadUnitTest.assertFalse((String)"Item should not have expired.", (boolean)result);
    }

    public void testCheckForRemoval_IdleTooLong() throws IOException {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMaxMemoryIdleTimeSeconds(10L);
        cacheAttr.setMaxSpoolPerRun(10);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        String key = "key";
        String value = "value";
        CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
        ElementAttributes elementAttr = new ElementAttributes();
        elementAttr.setIsEternal(false);
        element.setElementAttributes((IElementAttributes)elementAttr);
        element.getElementAttributes().setMaxLife(100L);
        element.getElementAttributes().setIdleTime(1L);
        long now = System.currentTimeMillis();
        boolean result = cache.isExpired((ICacheElement)element, now += 2000L, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND);
        ShrinkerThreadUnitTest.assertTrue((String)"Item should have expired.", (boolean)result);
    }

    public void testCheckForRemoval_NotIdleTooLong() throws IOException {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMaxMemoryIdleTimeSeconds(10L);
        cacheAttr.setMaxSpoolPerRun(10);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        String key = "key";
        String value = "value";
        CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
        ElementAttributes elementAttr = new ElementAttributes();
        elementAttr.setIsEternal(false);
        element.setElementAttributes((IElementAttributes)elementAttr);
        element.getElementAttributes().setMaxLife(100L);
        element.getElementAttributes().setIdleTime(1L);
        long now = System.currentTimeMillis();
        boolean result = cache.isExpired((ICacheElement)element, now -= 2000L, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND);
        ShrinkerThreadUnitTest.assertFalse((String)"Item should not have expired.", (boolean)result);
    }

    public void testSimpleShrink() throws Exception {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.MockMemoryCache");
        cacheAttr.setMaxMemoryIdleTimeSeconds(1L);
        cacheAttr.setMaxSpoolPerRun(10);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        MockMemoryCache memory = (MockMemoryCache)cache.getMemoryCache();
        String key = "key";
        String value = "value";
        CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
        ElementAttributes elementAttr = new ElementAttributes();
        elementAttr.setIsEternal(false);
        element.setElementAttributes((IElementAttributes)elementAttr);
        element.getElementAttributes().setMaxLife(1L);
        memory.update(element);
        ICacheElement returnedElement1 = memory.get(key);
        ShrinkerThreadUnitTest.assertNotNull((String)"We should have received an element", returnedElement1);
        ElementAttributesUtils.setLastAccessTime(elementAttr, System.currentTimeMillis() - 2000L);
        ShrinkerThread shrinker = new ShrinkerThread(cache);
        shrinker.run();
        Thread.sleep(500L);
        ICacheElement returnedElement2 = memory.get(key);
        ShrinkerThreadUnitTest.assertTrue((String)"Waterfall should have been called.", (memory.waterfallCallCount > 0 ? 1 : 0) != 0);
        ShrinkerThreadUnitTest.assertNull((String)"We not should have received an element.  It should have been spooled.", returnedElement2);
    }

    public void testSimpleShrinkMultiple() throws Exception {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.MockMemoryCache");
        cacheAttr.setMaxMemoryIdleTimeSeconds(1L);
        cacheAttr.setMaxSpoolPerRun(3);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        MockMemoryCache memory = (MockMemoryCache)cache.getMemoryCache();
        for (int i = 0; i < 10; ++i) {
            String key = "key" + i;
            String value = "value";
            CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
            ElementAttributes elementAttr = new ElementAttributes();
            elementAttr.setIsEternal(false);
            element.setElementAttributes((IElementAttributes)elementAttr);
            element.getElementAttributes().setMaxLife(1L);
            memory.update(element);
            ICacheElement returnedElement1 = memory.get(key);
            ShrinkerThreadUnitTest.assertNotNull((String)"We should have received an element", returnedElement1);
            ElementAttributesUtils.setLastAccessTime(elementAttr, System.currentTimeMillis() - 2000L);
        }
        ShrinkerThread shrinker = new ShrinkerThread(cache);
        shrinker.run();
        Thread.sleep(500L);
        ShrinkerThreadUnitTest.assertEquals((String)"Waterfall called the wrong number of times.", (int)3, (int)memory.waterfallCallCount);
        ShrinkerThreadUnitTest.assertEquals((String)"Wrong number of elements remain.", (int)7, (int)memory.getSize());
    }

    public void testSimpleShrinkMultipleWithEventHandler() throws Exception {
        CompositeCacheAttributes cacheAttr = new CompositeCacheAttributes();
        cacheAttr.setCacheName("testRegion");
        cacheAttr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.MockMemoryCache");
        cacheAttr.setMaxMemoryIdleTimeSeconds(1L);
        cacheAttr.setMaxSpoolPerRun(3);
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cacheAttr, (IElementAttributes)new ElementAttributes());
        MockMemoryCache memory = (MockMemoryCache)cache.getMemoryCache();
        ElementEventHandlerMockImpl handler = new ElementEventHandlerMockImpl();
        for (int i = 0; i < 10; ++i) {
            String key = "key" + i;
            String value = "value";
            CacheElement element = new CacheElement("testRegion", (Object)key, (Object)value);
            ElementAttributes elementAttr = new ElementAttributes();
            elementAttr.addElementEventHandler((IElementEventHandler)handler);
            elementAttr.setIsEternal(false);
            element.setElementAttributes((IElementAttributes)elementAttr);
            element.getElementAttributes().setMaxLife(1L);
            memory.update(element);
            ICacheElement returnedElement1 = memory.get(key);
            ShrinkerThreadUnitTest.assertNotNull((String)"We should have received an element", returnedElement1);
            ElementAttributesUtils.setLastAccessTime(elementAttr, System.currentTimeMillis() - 2000L);
        }
        ShrinkerThread shrinker = new ShrinkerThread(cache);
        shrinker.run();
        Thread.sleep(500L);
        ShrinkerThreadUnitTest.assertEquals((String)"Waterfall called the wrong number of times.", (int)3, (int)memory.waterfallCallCount);
        ShrinkerThreadUnitTest.assertEquals((String)"Wrong number of elements remain.", (int)7, (int)memory.getSize());
    }
}

