/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control.event;

import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;

public class SimpleEventHandlingUnitTest
extends TestCase {
    private static int items = 20000;

    public void setUp() {
        JCS.setConfigFilename((String)"/TestSimpleEventHandling.ccf");
    }

    public void testSpoolEvent() throws Exception {
        MyEventHandler meh = new MyEventHandler();
        CacheAccess jcs = JCS.getInstance((String)"WithDisk");
        IElementAttributes attributes = jcs.getDefaultElementAttributes();
        attributes.addElementEventHandler((IElementEventHandler)meh);
        jcs.setDefaultElementAttributes(attributes);
        for (int i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Thread.sleep(items / 20);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_SPOOLED_DISK_AVAILABLE events [" + meh.getSpoolCount() + "] does not equal the number expected [" + items + "]"), (meh.getSpoolCount() >= items ? 1 : 0) != 0);
    }

    public void testSpoolNoDiskEvent() throws Exception {
        CacheAccess jcs = JCS.getInstance((String)"NoDisk");
        MyEventHandler meh = new MyEventHandler();
        IElementAttributes attributes = jcs.getDefaultElementAttributes();
        attributes.addElementEventHandler((IElementEventHandler)meh);
        jcs.setDefaultElementAttributes(attributes);
        for (int i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Thread.sleep(items / 20);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_SPOOLED_DISK_NOT_AVAILABLE events  [" + meh.getSpoolNoDiskCount() + "] does not equal the number expected."), (meh.getSpoolNoDiskCount() >= items ? 1 : 0) != 0);
    }

    public void testSpoolNotAllowedEvent() throws Exception {
        MyEventHandler meh = new MyEventHandler();
        CacheAccess jcs = JCS.getInstance((String)"DiskButNotAllowed");
        IElementAttributes attributes = jcs.getDefaultElementAttributes();
        attributes.addElementEventHandler((IElementEventHandler)meh);
        jcs.setDefaultElementAttributes(attributes);
        for (int i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Thread.sleep(items / 20);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_SPOOLED_NOT_ALLOWED events [" + meh.getSpoolNotAllowedCount() + "] does not equal the number expected."), (meh.getSpoolNotAllowedCount() >= items ? 1 : 0) != 0);
    }

    public void testSpoolNotAllowedEventOnItem() throws Exception {
        MyEventHandler meh = new MyEventHandler();
        CacheAccess jcs = JCS.getInstance((String)"DiskButNotAllowed");
        for (int i = 0; i <= items; ++i) {
            IElementAttributes attributes = jcs.getDefaultElementAttributes();
            attributes.addElementEventHandler((IElementEventHandler)meh);
            jcs.put((Object)(i + ":key"), (Object)("data" + i), attributes);
        }
        Thread.sleep(items / 20);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_SPOOLED_NOT_ALLOWED events [" + meh.getSpoolNotAllowedCount() + "] does not equal the number expected."), (meh.getSpoolNotAllowedCount() >= items ? 1 : 0) != 0);
    }

    public void testExceededMaxlifeOnrequestEvent() throws Exception {
        int i;
        MyEventHandler meh = new MyEventHandler();
        CacheAccess jcs = JCS.getInstance((String)"Maxlife");
        IElementAttributes attributes = jcs.getDefaultElementAttributes();
        attributes.addElementEventHandler((IElementEventHandler)meh);
        jcs.setDefaultElementAttributes(attributes);
        for (i = 0; i < 200; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Thread.sleep(3000L);
        for (i = 0; i < 200; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            SimpleEventHandlingUnitTest.assertNull((String)("Item should be null for key " + i + ":key, but is " + value), (Object)value);
        }
        Thread.sleep(100L);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_EXCEEDED_MAXLIFE_ONREQUEST events [" + meh.getExceededMaxlifeCount() + "] does not equal the number expected."), (meh.getExceededMaxlifeCount() >= 200 ? 1 : 0) != 0);
    }

    public void testExceededIdletimeOnrequestEvent() throws Exception {
        String value;
        int i;
        MyEventHandler meh = new MyEventHandler();
        CacheAccess jcs = JCS.getInstance((String)"Idletime");
        IElementAttributes attributes = jcs.getDefaultElementAttributes();
        attributes.addElementEventHandler((IElementEventHandler)meh);
        jcs.setDefaultElementAttributes(attributes);
        for (i = 0; i < 200; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 0; i < 200; ++i) {
            value = (String)jcs.get((Object)(i + ":key"));
            SimpleEventHandlingUnitTest.assertNotNull((String)("Item should not be null for key " + i + ":key"), (Object)value);
        }
        Thread.sleep(1500L);
        for (i = 0; i < 200; ++i) {
            value = (String)jcs.get((Object)(i + ":key"));
            SimpleEventHandlingUnitTest.assertNull((String)("Item should be null for key " + i + ":key, but is " + value), (Object)value);
        }
        Thread.sleep(100L);
        SimpleEventHandlingUnitTest.assertTrue((String)("The number of ELEMENT_EVENT_EXCEEDED_IDLETIME_ONREQUEST events [" + meh.getExceededIdletimeCount() + "] does not equal the number expected."), (meh.getExceededIdletimeCount() >= 200 ? 1 : 0) != 0);
    }

    public void testElementAttributesCreationTime() throws Exception {
        ElementAttributes elem1 = new ElementAttributes();
        long ctime1 = elem1.getCreateTime();
        Thread.sleep(10L);
        IElementAttributes elem2 = elem1.clone();
        long ctime2 = elem2.getCreateTime();
        SimpleEventHandlingUnitTest.assertFalse((String)"Creation times should be different", (ctime1 == ctime2 ? 1 : 0) != 0);
    }

    public static class MyEventHandler
    implements IElementEventHandler {
        private int spoolCount = 0;
        private int spoolNotAllowedCount = 0;
        private int spoolNoDiskCount = 0;
        private int exceededMaxlifeCount = 0;
        private int exceededIdletimeCount = 0;

        public synchronized <T> void handleElementEvent(IElementEvent<T> event) {
            switch (event.getElementEvent()) {
                case SPOOLED_DISK_AVAILABLE: {
                    ++this.spoolCount;
                    break;
                }
                case SPOOLED_NOT_ALLOWED: {
                    ++this.spoolNotAllowedCount;
                    break;
                }
                case SPOOLED_DISK_NOT_AVAILABLE: {
                    ++this.spoolNoDiskCount;
                    break;
                }
                case EXCEEDED_MAXLIFE_ONREQUEST: {
                    ++this.exceededMaxlifeCount;
                    break;
                }
                case EXCEEDED_IDLETIME_ONREQUEST: {
                    ++this.exceededIdletimeCount;
                    break;
                }
                case EXCEEDED_IDLETIME_BACKGROUND: {
                    break;
                }
            }
        }

        protected int getSpoolCount() {
            return this.spoolCount;
        }

        protected int getSpoolNotAllowedCount() {
            return this.spoolNotAllowedCount;
        }

        protected int getSpoolNoDiskCount() {
            return this.spoolNoDiskCount;
        }

        protected int getExceededMaxlifeCount() {
            return this.exceededMaxlifeCount;
        }

        protected int getExceededIdletimeCount() {
            return this.exceededIdletimeCount;
        }
    }
}

