/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElementSerialized;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class RemoteCacheListenerUnitTest
extends TestCase {
    public void testUpdate_PutOnPut() throws Exception {
        RemoteCacheAttributes irca = new RemoteCacheAttributes();
        irca.setRemoveUponRemotePut(false);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        RemoteCacheListener listener = new RemoteCacheListener((IRemoteCacheAttributes)irca, (ICompositeCacheManager)cacheMgr, (IElementSerializer)new StandardSerializer());
        String cacheName = "testName";
        String key = "key";
        String value = "value fdsadf dsafdsa fdsaf dsafdsaf dsafdsaf dsaf dsaf dsaf dsafa dsaf dsaf dsafdsaf";
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(34L);
        StandardSerializer elementSerializer = new StandardSerializer();
        CacheElementSerialized element = new CacheElementSerialized(cacheName, (Object)key, elementSerializer.serialize((Object)value), (IElementAttributes)attr);
        listener.handlePut((ICacheElement)element);
        CompositeCache cache = cacheMgr.getCache(cacheName);
        ICacheElement after = cache.get((Object)key);
        RemoteCacheListenerUnitTest.assertNotNull((String)"Should have a deserialized object.", (Object)after);
        RemoteCacheListenerUnitTest.assertEquals((String)"Values should be the same.", (String)value, (String)((String)after.getVal()));
        RemoteCacheListenerUnitTest.assertEquals((String)"Attributes should be the same.", (long)attr.getMaxLife(), (long)after.getElementAttributes().getMaxLife());
        RemoteCacheListenerUnitTest.assertEquals((String)"Keys should be the same.", (String)key, (String)((String)after.getKey()));
        RemoteCacheListenerUnitTest.assertEquals((String)"Cache name should be the same.", (String)cacheName, (String)after.getCacheName());
    }

    public void testUpdate_RemoveOnPut() throws Exception {
        RemoteCacheAttributes irca = new RemoteCacheAttributes();
        irca.setRemoveUponRemotePut(true);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        RemoteCacheListener listener = new RemoteCacheListener((IRemoteCacheAttributes)irca, (ICompositeCacheManager)cacheMgr, (IElementSerializer)new StandardSerializer());
        String cacheName = "testName";
        String key = "key";
        String value = "value fdsadf dsafdsa fdsaf dsafdsaf dsafdsaf dsaf dsaf dsaf dsafa dsaf dsaf dsafdsaf";
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(34L);
        StandardSerializer elementSerializer = new StandardSerializer();
        CacheElementSerialized element = new CacheElementSerialized(cacheName, (Object)key, elementSerializer.serialize((Object)value), (IElementAttributes)attr);
        listener.handlePut((ICacheElement)element);
        CompositeCache cache = cacheMgr.getCache(cacheName);
        ICacheElement after = cache.get((Object)key);
        RemoteCacheListenerUnitTest.assertNull((String)"Should not have a deserialized object since remove on put is true.", (Object)after);
    }
}

