/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCommand;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPSender;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class TestTCPLateralUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestTCPLateralCache.ccf");
    }

    public void testSimpleSend() throws Exception {
        JCS.getInstance((String)"test");
        TCPLateralCacheAttributes lac = new TCPLateralCacheAttributes();
        lac.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lac.setTcpServer("localhost:8111");
        lac.setTcpListenerPort(8111);
        CompositeCacheManager cacheMgr = CompositeCacheManager.getInstance();
        LateralTCPListener listener = LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lac, (ICompositeCacheManager)cacheMgr);
        LateralTCPSender lur = new LateralTCPSender((ITCPLateralCacheAttributes)lac);
        int numMes = 10;
        for (int i = 0; i < numMes; ++i) {
            String message = "adsfasasfasfasdasf";
            CacheElement ce = new CacheElement("test", (Object)"test", (Object)message);
            LateralElementDescriptor led = new LateralElementDescriptor((ICacheElement)ce);
            led.command = LateralCommand.UPDATE;
            led.requesterId = 1L;
            lur.send(led);
        }
        SleepUtil.sleepAtLeast(numMes * 3);
        TestTCPLateralUnitTest.assertEquals((String)("Should have received " + numMes + " by now."), (int)numMes, (int)listener.getPutCnt());
    }

    public void testReceive() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1101);
        lattr.setTransmissionTypeName("TCP");
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1102);
        lattr2.setTransmissionTypeName("TCP");
        lattr2.setTcpServer("localhost:1101");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        int cnt = 100;
        for (int i = 0; i < cnt; ++i) {
            CacheElement element = new CacheElement("test", (Object)("key" + i), (Object)"value1");
            service.update((ICacheElement)element);
        }
        SleepUtil.sleepAtLeast(1000L);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct number", (long)cnt, (long)cacheMgr.getCache().getUpdateCount());
    }

    public void testSameKeyDifferentObject() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1103);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        CompositeCache cache = cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1104);
        lattr2.setTcpServer("localhost:1103");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value1");
        service.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(300L);
        CacheElement element2 = new CacheElement("test", (Object)"key", (Object)"value2");
        service.update((ICacheElement)element2);
        SleepUtil.sleepAtLeast(1000L);
        ICacheElement cacheElement = cache.get((Object)"key");
        TestTCPLateralUnitTest.assertEquals((String)("Didn't get the correct object " + cacheElement), (String)((String)element2.getVal()), (String)((String)cacheElement.getVal()));
    }

    public void testSameKeyObjectDifferentValueObject() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1105);
        lattr.setTransmissionTypeName("TCP");
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        CompositeCache cache = cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1106);
        lattr2.setTransmissionTypeName("TCP");
        lattr2.setTcpServer("localhost:1105");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        String key = "key";
        CacheElement element = new CacheElement("test", (Object)key, (Object)"value1");
        service.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(300L);
        CacheElement element2 = new CacheElement("test", (Object)key, (Object)"value2");
        service.update((ICacheElement)element2);
        SleepUtil.sleepAtLeast(1000L);
        ICacheElement cacheElement = cache.get((Object)"key");
        TestTCPLateralUnitTest.assertEquals((String)("Didn't get the correct object: " + cacheElement), (String)((String)element2.getVal()), (String)((String)cacheElement.getVal()));
    }

    public void testGet_SendAndReceived() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1107);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        CompositeCache cache = cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value1");
        cache.update((ICacheElement)element);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1108);
        lattr2.setTcpServer("localhost:1107");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        SleepUtil.sleepAtLeast(300L);
        ICacheElement result = service.get("test", (Object)"key");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct object", (String)((String)element.getVal()), (String)((String)result.getVal()));
    }

    public void testGetGroupKeys_SendAndReceived() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1150);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        CompositeCache cache = cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        GroupAttrName groupKey = new GroupAttrName(new GroupId("test", "group"), (Object)"key");
        CacheElement element = new CacheElement("test", (Object)groupKey, (Object)"value1");
        cache.update((ICacheElement)element);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1151);
        lattr2.setTcpServer("localhost:1150");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123459L);
        SleepUtil.sleepAtLeast(500L);
        Set result = service.getKeySet("test");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Didn't get the correct object", (String)"key", (String)((String)((GroupAttrName)result.iterator().next()).attrName));
    }

    public void testGetMatching_WithData() throws Exception {
        TCPLateralCacheAttributes lattr = new TCPLateralCacheAttributes();
        lattr.setTcpListenerPort(1108);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        CompositeCache cache = cacheMgr.getCache("test");
        LateralTCPListener.getInstance((ITCPLateralCacheAttributes)lattr, (ICompositeCacheManager)cacheMgr);
        String keyprefix1 = "MyPrefix1";
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < numToInsertPrefix1; ++i) {
            CacheElement element = new CacheElement("test", (Object)(keyprefix1 + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element);
        }
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1108);
        lattr2.setTcpServer("localhost:1108");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        SleepUtil.sleepAtLeast(300L);
        Map result = service.getMatching("test", keyprefix1 + ".+");
        TestTCPLateralUnitTest.assertNotNull((String)"Result should not be null.", (Object)result);
        TestTCPLateralUnitTest.assertEquals((String)"Wrong number returned 1:", (int)numToInsertPrefix1, (int)result.size());
    }
}

