/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.MockCacheEventLogger;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPDiscoveryListenerUnitTest
extends TestCase {
    private LateralTCPDiscoveryListener listener;
    private LateralTCPCacheFactory factory;
    private CompositeCacheManager cacheMgr;
    protected MockCacheEventLogger cacheEventLogger;
    protected IElementSerializer elementSerializer;

    protected void setUp() throws Exception {
        this.factory = new LateralTCPCacheFactory();
        this.factory.initialize();
        this.cacheMgr = CompositeCacheManager.getInstance();
        this.cacheEventLogger = new MockCacheEventLogger();
        this.elementSerializer = new StandardSerializer();
        this.listener = new LateralTCPDiscoveryListener(this.factory.getName(), (ICompositeCacheManager)this.cacheMgr);
    }

    public void testAddNoWaitFacade_NotInList() {
        String cacheName = "testAddNoWaitFacade_NotInList";
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have the facade.", (boolean)this.listener.containsNoWaitFacade(cacheName));
    }

    public void testAddNoWait_FacadeInList() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        boolean result = this.listener.addNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have added the no wait.", (boolean)result);
    }

    public void testAddNoWait_FacadeNotInList() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        boolean result = this.listener.addNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have added the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeNotInList() {
        String cacheName = "testRemoveNoWaitFacade_FacadeNotInList";
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have removed the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeInList_NoWaitNot() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have removed the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeInList_NoWaitIs() {
        String cacheName = "testRemoveNoWaitFacade_FacadeInListNoWaitIs";
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        this.listener.addNoWait(noWait);
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have removed the no wait.", (boolean)result);
    }

    public void testAddDiscoveredService_FacadeInList_NoWaitNot() {
        String cacheName = "testAddDiscoveredService_FacadeInList_NoWaitNot";
        ArrayList<String> cacheNames = new ArrayList<String>();
        cacheNames.add(cacheName);
        DiscoveredService service = new DiscoveredService();
        service.setCacheNames(cacheNames);
        service.setServiceAddress("localhost");
        service.setServicePort(9999);
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lca.setTcpServer(service.getServiceAddress() + ":" + service.getServicePort());
        lca.setCacheName(cacheName);
        LateralCacheNoWait noWait = this.factory.createCacheNoWait((ITCPLateralCacheAttributes)lca, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
        this.cacheMgr.addAuxiliaryCache(this.factory.getName(), cacheName, (AuxiliaryCache)noWait);
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        this.listener.addDiscoveredService(service);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have no wait.", (boolean)this.listener.containsNoWait(cacheName, noWait));
    }

    public void testRemoveDiscoveredService_FacadeInList_NoWaitIs() {
        String cacheName = "testRemoveDiscoveredService_FacadeInList_NoWaitIs";
        ArrayList<String> cacheNames = new ArrayList<String>();
        cacheNames.add(cacheName);
        DiscoveredService service = new DiscoveredService();
        service.setCacheNames(cacheNames);
        service.setServiceAddress("localhost");
        service.setServicePort(9999);
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lca.setTcpServer(service.getServiceAddress() + ":" + service.getServicePort());
        lca.setCacheName(cacheName);
        LateralCacheNoWait noWait = this.factory.createCacheNoWait((ITCPLateralCacheAttributes)lca, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
        this.cacheMgr.addAuxiliaryCache(this.factory.getName(), cacheName, (AuxiliaryCache)noWait);
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.listener.addNoWaitFacade(cacheName, facade);
        this.listener.addDiscoveredService(service);
        this.listener.removeDiscoveredService(service);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have no wait.", (boolean)this.listener.containsNoWait(cacheName, noWait));
    }
}

