/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.HsqlSetupTableUtil;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MySQLDiskCacheHsqlBackedUnitTest {
    @BeforeClass
    public static void setupDatabase() throws Exception {
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        String url = "jdbc:hsqldb:";
        String database = rafroot + "/MySQLDiskCacheHsqlBackedUnitTest";
        String user = "sa";
        String password = "";
        new jdbcDriver();
        Connection cConn = DriverManager.getConnection(url + database, user, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE_MYSQL");
    }

    @Before
    public void setUp() {
        JCS.setConfigFilename((String)"/TestMySQLDiskCache.ccf");
    }

    @Test
    public void testSimpleJDBCPutGetWithHSQL() throws Exception {
        this.runTestForRegion("testCache1", 200);
    }

    public void runTestForRegion(String region, int items) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 < items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        Thread.sleep(1000L);
        for (i2 = 0; i2 < items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            Assert.assertEquals((String)("key = [" + i2 + ":key] value = [" + value + "]"), (Object)(region + " data " + i2), (Object)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 < items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i < items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            Assert.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            Assert.assertEquals((String)("value " + i + ":key"), (Object)(region + " data " + i), (Object)element.getVal());
        }
        for (i = 0; i < items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i < items; ++i) {
            Assert.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }

    @Test
    public void testPutGetMatchingWithHSQL() throws Exception {
        int items = 200;
        String region = "testCache2";
        CacheAccess jcs = JCS.getInstance((String)region);
        for (int i = 0; i < items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
        }
        Thread.sleep(1000L);
        Map matchingResults = jcs.getMatchingCacheElements("1.8.+");
        Assert.assertEquals((String)"Wrong number returned", (long)10L, (long)matchingResults.size());
    }
}

