/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.hsql;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class HSQLDiskCacheConcurrentUnitTest
extends TestCase {
    private static int items = 100;

    public HSQLDiskCacheConcurrentUnitTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new HSQLDiskCacheConcurrentUnitTest("testHSQLDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion1");
            }
        });
        suite.addTest((Test)new HSQLDiskCacheConcurrentUnitTest("testHSQLDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion2");
            }
        });
        suite.addTest((Test)new HSQLDiskCacheConcurrentUnitTest("testHSQLDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion3");
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestHSQLDiskCacheConcurrent.ccf");
    }

    public void runTestForRegion(String region) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 <= items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        for (i2 = 0; i2 <= items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            HSQLDiskCacheConcurrentUnitTest.assertEquals((String)("key = [" + i2 + ":key] value = [" + value + "]"), (String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            HSQLDiskCacheConcurrentUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            HSQLDiskCacheConcurrentUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            HSQLDiskCacheConcurrentUnitTest.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

