/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.JndiDataSourceFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.SharedPoolDataSourceFactory;

public class JDBCDataSourceFactoryUnitTest
extends TestCase {
    public void testConfigureDataSourceFactory_Simple() throws SQLException {
        String poolName = "testConfigurePoolAccessAttributes_Simple";
        String url = "adfads";
        String userName = "zvzvz";
        String password = "qewrrewq";
        int maxActive = 10;
        String driverClassName = "org.hsqldb.jdbcDriver";
        Properties props = new Properties();
        String prefix = "jcs.jdbcconnectionpool." + poolName + ".attributes";
        props.put(prefix + ".url", url);
        props.put(prefix + ".userName", userName);
        props.put(prefix + ".password", password);
        props.put(prefix + ".maxActive", String.valueOf(maxActive));
        props.put(prefix + ".driverClassName", driverClassName);
        JDBCDiskCacheFactory factory = new JDBCDiskCacheFactory();
        factory.initialize();
        JDBCDiskCacheAttributes cattr = new JDBCDiskCacheAttributes();
        cattr.setConnectionPoolName(poolName);
        DataSourceFactory result = factory.getDataSourceFactory(cattr, props);
        JDBCDataSourceFactoryUnitTest.assertTrue((String)"Should be a shared pool data source factory", (boolean)(result instanceof SharedPoolDataSourceFactory));
        SharedPoolDataSource spds = (SharedPoolDataSource)result.getDataSource();
        JDBCDataSourceFactoryUnitTest.assertNotNull((String)"Should have a data source class", (Object)spds);
        JDBCDataSourceFactoryUnitTest.assertEquals((String)"Wrong pool name", (String)poolName, (String)spds.getDescription());
        JDBCDataSourceFactoryUnitTest.assertEquals((String)"Wrong maxActive value", (int)maxActive, (int)spds.getMaxTotal());
    }

    public void testConfigureDataSourceFactory_Attributes() throws SQLException {
        String url = "adfads";
        String userName = "zvzvz";
        String password = "qewrrewq";
        int maxActive = 10;
        String driverClassName = "org.hsqldb.jdbcDriver";
        JDBCDiskCacheFactory factory = new JDBCDiskCacheFactory();
        factory.initialize();
        JDBCDiskCacheAttributes cattr = new JDBCDiskCacheAttributes();
        cattr.setUrl(url);
        cattr.setUserName(userName);
        cattr.setPassword(password);
        cattr.setMaxTotal(maxActive);
        cattr.setDriverClassName(driverClassName);
        DataSourceFactory result = factory.getDataSourceFactory(cattr, null);
        JDBCDataSourceFactoryUnitTest.assertTrue((String)"Should be a shared pool data source factory", (boolean)(result instanceof SharedPoolDataSourceFactory));
        SharedPoolDataSource spds = (SharedPoolDataSource)result.getDataSource();
        JDBCDataSourceFactoryUnitTest.assertNotNull((String)"Should have a data source class", (Object)spds);
        JDBCDataSourceFactoryUnitTest.assertEquals((String)"Wrong maxActive value", (int)maxActive, (int)spds.getMaxTotal());
    }

    public void testConfigureDataSourceFactory_JNDI() throws SQLException {
        String jndiPath = "java:comp/env/jdbc/MyDB";
        long ttl = 300000L;
        System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
        MockInitialContextFactory.bind(jndiPath, new BasicDataSource());
        JDBCDiskCacheFactory factory = new JDBCDiskCacheFactory();
        factory.initialize();
        JDBCDiskCacheAttributes cattr = new JDBCDiskCacheAttributes();
        cattr.setJndiPath(jndiPath);
        cattr.setJndiTTL(ttl);
        DataSourceFactory result = factory.getDataSourceFactory(cattr, null);
        JDBCDataSourceFactoryUnitTest.assertTrue((String)"Should be a JNDI data source factory", (boolean)(result instanceof JndiDataSourceFactory));
    }

    public static class MockInitialContextFactory
    implements InitialContextFactory {
        private static Context context;

        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return context;
        }

        public static void bind(String name, Object obj) {
            try {
                context.bind(name, obj);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                context = new InitialContext(true){
                    Map<String, Object> bindings = new HashMap<String, Object>();

                    @Override
                    public void bind(String name, Object obj) throws NamingException {
                        this.bindings.put(name, obj);
                    }

                    @Override
                    public Object lookup(String name) throws NamingException {
                        return this.bindings.get(name);
                    }

                    @Override
                    public Hashtable<?, ?> getEnvironment() throws NamingException {
                        return new Hashtable();
                    }
                };
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

