/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class BlockDiskCacheConcurrentUnitTest
extends TestCase {
    private static int items = 200;

    public BlockDiskCacheConcurrentUnitTest(String testName) throws Exception {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{BlockDiskCacheConcurrentUnitTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() throws Exception {
        ActiveTestSuite suite = new ActiveTestSuite();
        JCS.setConfigFilename((String)"/TestBlockDiskCache.ccf");
        JCS.getInstance((String)"indexedRegion1").clear();
        JCS.getInstance((String)"indexedRegion2").clear();
        JCS.getInstance((String)"indexedRegion3").clear();
        suite.addTest((Test)new BlockDiskCacheConcurrentUnitTest("testBlockDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion1");
            }
        });
        suite.addTest((Test)new BlockDiskCacheConcurrentUnitTest("testBlockDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion2");
            }
        });
        suite.addTest((Test)new BlockDiskCacheConcurrentUnitTest("testBlockDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion3");
            }
        });
        suite.addTest((Test)new BlockDiskCacheConcurrentUnitTest("testBlockDiskCache4"){

            public void runTest() throws Exception {
                this.runTestForRegionInRange("indexedRegion3", 300, 600);
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestBlockDiskCache.ccf");
    }

    public void runTestForRegion(String region) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 <= items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        for (i2 = 0; i2 <= items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            BlockDiskCacheConcurrentUnitTest.assertEquals((String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            BlockDiskCacheConcurrentUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            BlockDiskCacheConcurrentUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            BlockDiskCacheConcurrentUnitTest.assertNull((String)("Removed key should be null: " + i + ":key\n stats " + jcs.getStats()), (Object)jcs.get((Object)(i + ":key")));
        }
    }

    public void runTestForRegionInRange(String region, int start, int end) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = start; i2 <= end; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        for (i2 = start; i2 <= end; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            BlockDiskCacheConcurrentUnitTest.assertEquals((String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = start; i3 <= end; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = start; i <= end; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            BlockDiskCacheConcurrentUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            BlockDiskCacheConcurrentUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = start; i <= end; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = start; i <= end; ++i) {
            BlockDiskCacheConcurrentUnitTest.assertNull((String)("Removed key should be null: " + i + ":key \n stats " + jcs.getStats()), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

