/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.PurgatoryElement;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;

public class PurgatoryElementUnitTest
extends TestCase {
    public void testSpoolable_normal() {
        String cacheName = "myCacheName";
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        PurgatoryElement purgatoryElement = new PurgatoryElement((ICacheElement)cacheElement);
        purgatoryElement.setSpoolable(false);
        boolean result = purgatoryElement.isSpoolable();
        PurgatoryElementUnitTest.assertFalse((String)"Should not be spoolable.", (boolean)result);
    }

    public void testElementAttributes_normal() {
        String cacheName = "myCacheName";
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value);
        PurgatoryElement purgatoryElement = new PurgatoryElement((ICacheElement)cacheElement);
        purgatoryElement.setElementAttributes((IElementAttributes)elementAttributes);
        IElementAttributes result = cacheElement.getElementAttributes();
        PurgatoryElementUnitTest.assertEquals((String)"Should have set the attributes on the element", (Object)elementAttributes, (Object)result);
    }

    public void testToString_normal() {
        String cacheName = "myCacheName";
        String key = "myKey";
        String value = "myValue";
        ElementAttributes elementAttributes = new ElementAttributes();
        CacheElement cacheElement = new CacheElement(cacheName, (Object)key, (Object)value, (IElementAttributes)elementAttributes);
        PurgatoryElement purgatoryElement = new PurgatoryElement((ICacheElement)cacheElement);
        String result = purgatoryElement.toString();
        PurgatoryElementUnitTest.assertTrue((String)"Should have the cacheName.", (result.indexOf(cacheName) != -1 ? 1 : 0) != 0);
        PurgatoryElementUnitTest.assertTrue((String)"Should have the key.", (result.indexOf(key) != -1 ? 1 : 0) != 0);
        PurgatoryElementUnitTest.assertTrue((String)"Should have the value.", (result.indexOf(value) != -1 ? 1 : 0) != 0);
    }
}

