/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.access;

import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SystemPropertyUnitTest
extends TestCase {
    public void test1SystemPropertyInValueDelimiter() throws Exception {
        int maxMemory = 1234;
        System.getProperties().setProperty("MY_SYSTEM_PROPERTY_DISK_DIR", "system_set");
        System.getProperties().setProperty("MY_SYSTEM_PROPERTY_MAX_SIZE", String.valueOf(maxMemory));
        JCS.setConfigFilename((String)"/TestSystemProperties.ccf");
        CacheAccess cache = JCS.getInstance((String)"test1");
        SystemPropertyUnitTest.assertEquals((String)"We should have used the system property for the memory size", (int)maxMemory, (int)cache.getCacheAttributes().getMaxObjects());
        System.clearProperty("MY_SYSTEM_PROPERTY_DISK_DIR");
        System.clearProperty("MY_SYSTEM_PROPERTY_MAX_SIZE");
    }

    public void test2SystemPropertyMissingInValueDelimeter() throws Exception {
        System.getProperties().setProperty("MY_SYSTEM_PROPERTY_DISK_DIR", "system_set");
        CompositeCacheManager mgr = CompositeCacheManager.getUnconfiguredInstance();
        mgr.configure("/TestSystemProperties.ccf");
        CacheAccess cache = JCS.getInstance((String)"missing");
        SystemPropertyUnitTest.assertEquals((String)"We should have used the default property for the memory size", (int)100, (int)cache.getCacheAttributes().getMaxObjects());
        System.clearProperty("MY_SYSTEM_PROPERTY_DISK_DIR");
    }
}

