/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.jakarta.servlet6;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractFileUploadTest;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaMockHttpServletRequest;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaMockServletHttpRequest;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletRequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JakartaServletFileUploadDiskTest
extends AbstractFileUploadTest<JakartaServletDiskFileUpload, HttpServletRequest, DiskFileItem, DiskFileItemFactory> {
    public JakartaServletFileUploadDiskTest() {
        super((AbstractFileUpload)new JakartaServletDiskFileUpload());
    }

    public List<DiskFileItem> parseUpload(JakartaServletDiskFileUpload upload, byte[] bytes, String contentType) throws FileUploadException {
        JakartaMockHttpServletRequest request = new JakartaMockHttpServletRequest(bytes, contentType);
        return upload.parseRequest((RequestContext)new JakartaServletRequestContext((HttpServletRequest)request));
    }

    @Test
    public void testParseImpliedUtf8() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\u00eds \u00eds the co\u00f1te\u00f1t of the f\u00edle\n\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\u00eds \u00eds the co\u00f1te\u00f1t of the f\u00edle\n\r\n-----1234--\r\n".getBytes(StandardCharsets.UTF_8);
        JakartaMockServletHttpRequest request = new JakartaMockServletHttpRequest(bytes, "multipart/form-data; boundary=---1234");
        DiskFileItemFactory fileItemFactory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setCharset(StandardCharsets.UTF_8)).get();
        JakartaServletDiskFileUpload upload = new JakartaServletDiskFileUpload(fileItemFactory);
        List fileItems = upload.parseRequest((HttpServletRequest)request);
        DiskFileItem fileItem = (DiskFileItem)fileItems.get(0);
        Assertions.assertTrue((boolean)fileItem.getString().contains("co\u00f1te\u00f1t"), (String)fileItem.getString());
    }

    @Test
    public void testParseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII);
        JakartaMockServletHttpRequest request = new JakartaMockServletHttpRequest(bytes, "multipart/form-data; boundary=---1234");
        JakartaServletDiskFileUpload upload = new JakartaServletDiskFileUpload();
        Map mappedParameters = upload.parseParameterMap((HttpServletRequest)request);
        Assertions.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("file")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("field")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assertions.assertEquals((int)2, (int)((List)mappedParameters.get("multi")).size());
    }
}

